/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.mode.layer;

import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.mode.layer.AbstractLayerMode;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.SelectedLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.SendLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.EmptyParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.RangeFilterParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Arrays;
import java.util.Optional;

public class LayerMode
extends AbstractLayerMode {
    public LayerMode(MCUControlSurface surface, IModel model) {
        super("Layer", surface, model);
        int surfaceID;
        IParameterProvider parameterProvider = this.pinFXtoLastDevice ? new VolumeParameterProvider(model.getEffectTrackBank()) : ((surfaceID = surface.getSurfaceID()) == 0 ? new RangeFilterParameterProvider(new SelectedLayerOrDrumPadParameterProvider(LayerMode.getDevice(model)), 0, 8) : (surfaceID == 1 ? new RangeFilterParameterProvider(new SendLayerOrDrumPadParameterProvider(LayerMode.getDevice(model), 6), 0, 8) : new EmptyParameterProvider(8)));
        this.setParameterProvider(parameterProvider);
    }

    @Override
    public void updateKnobLEDs() {
        int[] ledModes = new int[8];
        Arrays.fill(ledModes, 2);
        if (this.getExtenderOffset() == 0 && this.getParameterProvider().get(1).doesExist()) {
            ledModes[1] = 1;
        }
        this.updateKnobLEDs(ledModes);
    }

    @Override
    protected void drawTrackNameHeader() {
        this.drawParameterHeader();
    }

    @Override
    protected void drawParameterHeader(ITextDisplay display, int row) {
        super.drawParameterHeader(display, row);
        if (((MCUControlSurface)this.surface).getExtenderOffset() == 0 && this.configuration.isDisplayTrackNames()) {
            ISpecificDevice device = LayerMode.getDevice(this.model);
            ILayerBank layerBank = device.hasDrumPads() ? device.getDrumPadBank() : device.getLayerBank();
            Optional selectedLayer = layerBank.getSelectedItem();
            if (selectedLayer.isEmpty()) {
                return;
            }
            display.setCell(row, 0, StringUtils.shortenAndFixASCII(((IChannel)selectedLayer.get()).getName(), this.getTextLength()));
            display.done(row);
        }
    }

    @Override
    protected void updateItemIndices() {
        ISpecificDevice device;
        ILayerBank layerBank;
        Optional selectedItem;
        int[] indices = new int[8];
        Arrays.fill(indices, 0);
        if (this.getExtenderOffset() == 0 && (selectedItem = (layerBank = (device = LayerMode.getDevice(this.model)).hasDrumPads() ? device.getDrumPadBank() : device.getLayerBank()).getSelectedItem()).isPresent()) {
            indices[0] = ((IChannel)selectedItem.get()).getPosition() + 1;
        }
        ((MCUControlSurface)this.surface).setItemIndices(indices);
    }
}

