/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.mode.device;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.IEqualizerDevice;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IDeviceBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.RangeFilterParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Arrays;
import java.util.Optional;

public class DeviceParamsMode
extends BaseMode<IParameter> {
    private final ISpecificDevice device;

    public DeviceParamsMode(MCUControlSurface surface, IModel model) {
        this("Device Parameters", model.getCursorDevice(), surface, model);
    }

    public DeviceParamsMode(String name, ISpecificDevice device, MCUControlSurface surface, IModel model) {
        super(name, surface, model, device.getParameterBank());
        IParameterProvider parameterProvider;
        this.device = device;
        if (this.pinFXtoLastDevice) {
            parameterProvider = new VolumeParameterProvider(model.getEffectTrackBank());
        } else {
            int surfaceID = surface.getSurfaceID();
            parameterProvider = new RangeFilterParameterProvider(new BankParameterProvider(device.getParameterBank()), surfaceID * 8, 8);
            if (this.device instanceof IEqualizerDevice) {
                this.model.getTrackBank().addSelectionObserver(this::trackSelectionChanged);
                ITrackBank effectTrackBank = this.model.getEffectTrackBank();
                if (effectTrackBank != null) {
                    effectTrackBank.addSelectionObserver(this::trackSelectionChanged);
                }
            }
        }
        this.setParameterProvider(parameterProvider);
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.trackSelectionChanged(-1, true);
    }

    private void trackSelectionChanged(int index, boolean isSelected) {
        Optional selectedTrack;
        if (!(isSelected && this.isActive && this.device instanceof IEqualizerDevice)) {
            return;
        }
        if (!this.device.doesExist() && ((MCUControlSurface)this.surface).getSurfaceID() == 0 && (selectedTrack = this.model.getCurrentTrackBank().getSelectedItem()).isPresent()) {
            ((ITrack)selectedTrack.get()).addEqualizerDevice();
        }
    }

    @Override
    public void updateDisplay() {
        boolean isControlPressed = ((MCUControlSurface)this.surface).isPressed(ButtonID.CONTROL);
        if (isControlPressed || ((MCUControlSurface)this.surface).isSelectPressed()) {
            ColorEx[] colors = new ColorEx[8];
            ITextDisplay d = ((MCUControlSurface)this.surface).getTextDisplay().clear();
            int textLength = this.getTextLength();
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            if (isControlPressed) {
                IDeviceBank deviceBank = cursorDevice.getDeviceBank();
                int extenderOffset = this.getExtenderOffset();
                for (int i = 0; i < 8; ++i) {
                    IDevice device = (IDevice)deviceBank.getItem(extenderOffset + i);
                    if (device.doesExist()) {
                        d.setCell(0, i, StringUtils.shortenAndFixASCII(device.getName(), textLength));
                        colors[i] = ColorEx.WHITE;
                        continue;
                    }
                    colors[i] = ColorEx.BLACK;
                }
            } else {
                IParameterPageBank pageBank = cursorDevice.getParameterBank().getPageBank();
                int extenderOffset = this.getExtenderOffset();
                for (int i = 0; i < 8; ++i) {
                    String page = (String)pageBank.getItem(extenderOffset + i);
                    if (page != null && !page.isBlank()) {
                        d.setCell(0, i, StringUtils.shortenAndFixASCII(page, textLength));
                        colors[i] = ColorEx.WHITE;
                        continue;
                    }
                    colors[i] = ColorEx.BLACK;
                }
            }
            d.allDone();
            ((MCUControlSurface)this.surface).sendDisplayColor(colors);
            return;
        }
        super.updateDisplay();
        int[] indices = new int[8];
        Arrays.fill(indices, 0);
        if (this.getExtenderOffset() == 0) {
            ICursorTrack selectedTrack = this.model.getCursorTrack();
            if (selectedTrack.doesExist()) {
                indices[0] = selectedTrack.getPosition() + 1;
            }
            if (this.device.doesExist()) {
                indices[1] = this.device.getPosition() + 1;
                indices[2] = this.device.getParameterBank().getPageBank().getSelectedItemIndex() + 1;
            }
        }
        ((MCUControlSurface)this.surface).setItemIndices(indices);
    }

    @Override
    protected void drawTrackNameHeader() {
        if (this.pinFXtoLastDevice) {
            super.drawTrackNameHeader();
            return;
        }
        this.drawParameterHeader();
        if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).getMainDisplayType() == MCUConfiguration.MainDisplay.ASPARION && ((MCUControlSurface)this.surface).getSurfaceID() == 0) {
            ITextDisplay display = ((MCUControlSurface)this.surface).getTextDisplay();
            display.clearRow(0);
            ICursorTrack selectedTrack = this.model.getCursorTrack();
            if (selectedTrack.doesExist()) {
                int textLength = this.getTextLength();
                display.setCell(0, 0, StringUtils.shortenAndFixASCII(selectedTrack.getName(), textLength));
                if (this.device.doesExist()) {
                    display.setCell(0, 1, StringUtils.shortenAndFixASCII(this.device.getName(), textLength));
                    IParameterPageBank pageBank = this.device.getParameterBank().getPageBank();
                    Optional selectedPage = pageBank.getSelectedItem();
                    if (selectedPage.isPresent()) {
                        display.setCell(0, 2, StringUtils.shortenAndFixASCII((String)selectedPage.get(), textLength));
                        display.setCell(0, 3, "Page " + (pageBank.getSelectedItemIndex() + 1) + "/" + pageBank.getItemCount());
                    }
                }
            }
            display.done(0);
        }
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (row == 0) {
            if (((MCUControlSurface)this.surface).isPressed(ButtonID.CONTROL)) {
                ICursorDevice cursorDevice;
                if (event == ButtonEvent.DOWN && (cursorDevice = this.model.getCursorDevice()).doesExist()) {
                    IDeviceBank deviceBank = cursorDevice.getDeviceBank();
                    int pageSize = deviceBank.getPageSize();
                    int pos = cursorDevice.getPosition() / pageSize * pageSize;
                    deviceBank.selectItemAtPosition(pos + this.getExtenderOffset() + index);
                }
                return;
            }
            if (((MCUControlSurface)this.surface).isSelectPressed()) {
                ICursorDevice cursorDevice;
                if (event == ButtonEvent.DOWN && (cursorDevice = this.model.getCursorDevice()).doesExist()) {
                    IParameterPageBank pageBank = cursorDevice.getParameterBank().getPageBank();
                    int pageSize = pageBank.getPageSize();
                    int pos = pageBank.getSelectedItemPosition() / pageSize * pageSize;
                    pageBank.selectItemAtPosition(pos + this.getExtenderOffset() + index);
                }
                return;
            }
        }
        super.onButton(row, index, event);
    }

    @Override
    public void updateKnobLEDs() {
        boolean isControlPressed = ((MCUControlSurface)this.surface).isPressed(ButtonID.CONTROL);
        if (isControlPressed || ((MCUControlSurface)this.surface).isSelectPressed()) {
            int upperBound = this.model.getValueChanger().getUpperBound();
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            int extenderOffset = this.getExtenderOffset();
            if (isControlPressed) {
                IDeviceBank deviceBank = cursorDevice.getDeviceBank();
                int selectedPosition = cursorDevice.getPosition();
                for (int i = 0; i < 8; ++i) {
                    IDevice device = (IDevice)deviceBank.getItem(extenderOffset + i);
                    ((MCUControlSurface)this.surface).setKnobLED(i, 2, device.doesExist() && device.getPosition() == selectedPosition ? upperBound - 1 : 0, upperBound);
                }
            } else {
                IParameterPageBank pageBank = cursorDevice.getParameterBank().getPageBank();
                int selectedPosition = pageBank.getSelectedItemPosition();
                for (int i = 0; i < 8; ++i) {
                    String page = (String)pageBank.getItem(extenderOffset + i);
                    ((MCUControlSurface)this.surface).setKnobLED(i, 2, page != null && !page.isBlank() && extenderOffset + i == selectedPosition ? upperBound - 1 : 0, upperBound);
                }
            }
            return;
        }
        super.updateKnobLEDs();
    }
}

