/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.controller;

import de.mossgrabers.framework.controller.display.AbstractTextDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;

public class MCUSegmentDisplay
extends AbstractTextDisplay {
    private final int[] transportBuffer = new int[10];

    public MCUSegmentDisplay(IHost host, IMidiOutput output) {
        super(host, output, 1, 1, 20);
    }

    @Override
    public void writeLine(int row, String text, String previousText) {
        boolean addDot = false;
        int pos = text.length() - 1;
        int i = 0;
        while (i < 10) {
            int c = 32;
            if (pos >= 0) {
                boolean isDot;
                char singleDigit = text.charAt(pos);
                --pos;
                boolean bl = isDot = singleDigit == ':';
                if (isDot) {
                    addDot = isDot;
                    continue;
                }
                c = singleDigit;
                if (addDot) {
                    c += 64;
                }
            }
            if (c != this.transportBuffer[i]) {
                this.output.sendCC(64 + i, c);
                this.transportBuffer[i] = c;
            }
            ++i;
            addDot = false;
        }
    }

    @Override
    public void shutdown() {
        for (int i = 0; i < 12; ++i) {
            this.output.sendCC(64 + i, 32);
        }
    }
}

