/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.command.trigger;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.mode.device.MCUProjectParametersMode;
import de.mossgrabers.controller.mackie.mcu.mode.device.MCUTrackParametersMode;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Optional;

public class MCUMoveTrackBankCommand
extends AbstractTriggerCommand<MCUControlSurface, MCUConfiguration> {
    protected final boolean moveLeft;
    protected final boolean moveBy1;

    public MCUMoveTrackBankCommand(IModel model, MCUControlSurface surface, boolean moveBy1, boolean moveLeft) {
        super(model, surface);
        this.moveBy1 = moveBy1;
        this.moveLeft = moveLeft;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (((MCUControlSurface)this.surface).isSelectPressed()) {
            if (this.moveBy1) {
                ICursorTrack cursorTrack = this.model.getCursorTrack();
                if (this.moveLeft) {
                    cursorTrack.swapWithPrevious();
                } else {
                    cursorTrack.swapWithNext();
                }
            } else {
                ICursorDevice cursorDevice = this.model.getCursorDevice();
                if (this.moveLeft) {
                    cursorDevice.swapWithPrevious();
                } else {
                    cursorDevice.swapWithNext();
                }
            }
            return;
        }
        boolean shouldNotify = ((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).getMainDisplayType() != MCUConfiguration.MainDisplay.ASPARION;
        ModeManager modeManager = ((MCUControlSurface)this.surface).getModeManager();
        Modes activeID = (Modes)((Object)modeManager.getActiveID());
        switch (activeID) {
            case EQ_DEVICE_PARAMS: 
            case INSTRUMENT_DEVICE_PARAMS: 
            case DEVICE_PARAMS: {
                ISpecificDevice device = this.getDevice(activeID);
                if (this.moveBy1) {
                    this.handleBankMovement(device.getParameterBank());
                } else if (device instanceof ICursorDevice) {
                    ICursorDevice cursorDevice = (ICursorDevice)device;
                    if (this.moveLeft) {
                        cursorDevice.selectPrevious();
                    } else {
                        cursorDevice.selectNext();
                    }
                }
                if (!shouldNotify) break;
                this.notifySelectedDeviceAndParameterPage();
                break;
            }
            case PROJECT_PARAMETERS: {
                MCUProjectParametersMode projectMode = (MCUProjectParametersMode)modeManager.get(Modes.PROJECT_PARAMETERS);
                this.handleBankMovement(projectMode.getBank());
                if (!shouldNotify) break;
                this.notifySelectedParameterPage(true);
                break;
            }
            case TRACK_PARAMETERS: {
                MCUTrackParametersMode trackMode = (MCUTrackParametersMode)modeManager.get(Modes.TRACK_PARAMETERS);
                this.handleBankMovement(trackMode.getBank());
                if (!shouldNotify) break;
                this.notifySelectedParameterPage(false);
                break;
            }
            case MARKERS: {
                this.handleBankMovement(this.model.getMarkerBank());
                break;
            }
            case DEVICE_LAYER: 
            case DEVICE_LAYER_VOLUME: 
            case DEVICE_LAYER_PAN: 
            case DEVICE_LAYER_SEND1: 
            case DEVICE_LAYER_SEND2: 
            case DEVICE_LAYER_SEND3: 
            case DEVICE_LAYER_SEND4: 
            case DEVICE_LAYER_SEND5: 
            case DEVICE_LAYER_SEND6: 
            case DEVICE_LAYER_SEND7: 
            case DEVICE_LAYER_SEND8: {
                this.handleModeMovement((IMode)modeManager.getActive());
                break;
            }
            default: {
                this.handleBankMovement(this.model.getCurrentTrackBank());
            }
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN || !((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).shouldPinFXTracksToLastController()) {
            return;
        }
        ITrackBank effectTrackBank = this.model.getEffectTrackBank();
        if (effectTrackBank != null) {
            this.handleBankMovement(effectTrackBank);
        }
    }

    private void handleBankMovement(IBank<?> bank) {
        if (this.moveBy1) {
            if (this.moveLeft) {
                bank.scrollBackwards();
            } else {
                bank.scrollForwards();
            }
        } else if (this.moveLeft) {
            bank.selectPreviousPage();
        } else {
            bank.selectNextPage();
        }
    }

    private void handleModeMovement(IMode mode) {
        if (this.moveBy1) {
            if (this.moveLeft) {
                mode.selectPreviousItem();
            } else {
                mode.selectNextItem();
            }
        } else if (this.moveLeft) {
            mode.selectPreviousItemPage();
        } else {
            mode.selectNextItemPage();
        }
    }

    private ISpecificDevice getDevice(Modes modeID) {
        switch (modeID) {
            case EQ_DEVICE_PARAMS: {
                return this.model.getSpecificDevice(DeviceID.EQ);
            }
            case INSTRUMENT_DEVICE_PARAMS: {
                return this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
            }
        }
        return this.model.getCursorDevice();
    }

    private void notifySelectedDeviceAndParameterPage() {
        this.mvHelper.delayDisplay(() -> {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            if (!cursorDevice.doesExist()) {
                return "No device selected";
            }
            Object text = StringUtils.pad(StringUtils.shortenAndFixASCII(cursorDevice.getName(), 27) + " ", 28);
            Optional selectedItem = cursorDevice.getParameterBank().getPageBank().getSelectedItem();
            if (selectedItem.isPresent()) {
                String pageName = (String)selectedItem.get();
                if (pageName == null || pageName.isBlank()) {
                    pageName = "None";
                }
                text = (String)text + pageName;
            }
            return text;
        });
    }

    private void notifySelectedParameterPage(boolean isProjectParameters) {
        this.mvHelper.delayDisplay(() -> {
            AbstractParameterMode parameterMode;
            Optional selectedItem;
            Object text;
            IMode mode = (IMode)((MCUControlSurface)this.surface).getModeManager().get(isProjectParameters ? Modes.PROJECT_PARAMETERS : Modes.TRACK_PARAMETERS);
            if (isProjectParameters) {
                text = "Project";
            } else {
                text = "Track: ";
                ICursorTrack cursorTrack = this.model.getCursorTrack();
                text = cursorTrack.doesExist() ? (String)text + cursorTrack.getName() : (String)text + "None";
            }
            text = StringUtils.pad((String)text, 28);
            if (mode instanceof AbstractParameterMode && (selectedItem = ((IParameterBank)(parameterMode = (AbstractParameterMode)mode).getBank()).getPageBank().getSelectedItem()).isPresent()) {
                String pageName = (String)selectedItem.get();
                if (pageName == null || pageName.isBlank()) {
                    pageName = "None";
                }
                text = (String)text + pageName;
            }
            return text;
        });
    }
}

