/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.hui.mode.device;

import de.mossgrabers.controller.mackie.hui.HUIConfiguration;
import de.mossgrabers.controller.mackie.hui.controller.HUIControlSurface;
import de.mossgrabers.controller.mackie.hui.mode.HUIMode;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IEqualizerDevice;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Optional;

public class DeviceParamsMode
extends AbstractParameterMode<HUIControlSurface, HUIConfiguration, IParameter>
implements HUIMode {
    private final ISpecificDevice device;

    public DeviceParamsMode(HUIControlSurface surface, IModel model) {
        this("Parameters", model.getCursorDevice(), surface, model);
    }

    public DeviceParamsMode(String name, ISpecificDevice device, HUIControlSurface surface, IModel model) {
        super(name, surface, model, false, device.getParameterBank());
        this.device = device;
        if (this.device instanceof IEqualizerDevice) {
            this.model.getTrackBank().addSelectionObserver(this::trackSelectionChanged);
            ITrackBank effectTrackBank = this.model.getEffectTrackBank();
            if (effectTrackBank != null) {
                effectTrackBank.addSelectionObserver(this::trackSelectionChanged);
            }
        }
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.trackSelectionChanged(-1, true);
    }

    private void trackSelectionChanged(int index, boolean isSelected) {
        Optional selectedTrack;
        if (!(isSelected && this.isActive && this.device instanceof IEqualizerDevice)) {
            return;
        }
        if (!this.device.doesExist() && ((HUIControlSurface)this.surface).getSurfaceID() == 0 && (selectedTrack = this.model.getCurrentTrackBank().getSelectedItem()).isPresent()) {
            ((ITrack)selectedTrack.get()).addEqualizerDevice();
        }
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((HUIControlSurface)this.surface).getTextDisplay().clear();
        IParameterBank parameterBank = this.device.getParameterBank();
        for (int i = 0; i < 8; ++i) {
            IParameter param = (IParameter)parameterBank.getItem(i);
            if (!param.doesExist()) continue;
            d.setCell(0, i, StringUtils.shortenAndFixASCII(param.getName(), 4));
        }
        d.done(0);
    }

    @Override
    public void updateKnobLEDs() {
        int upperBound = this.model.getValueChanger().getUpperBound();
        IParameterBank parameterBank = this.device.getParameterBank();
        if (((HUIControlSurface)this.surface).getExtenderOffset() == 0) {
            for (int i = 0; i < 8; ++i) {
                IParameter param = (IParameter)parameterBank.getItem(i);
                if (param.doesExist()) {
                    ((HUIControlSurface)this.surface).setKnobLED(i, 2, Math.max(param.getValue(), 1), upperBound);
                    continue;
                }
                ((HUIControlSurface)this.surface).setKnobLED(i, -1, 0, 0);
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                ((HUIControlSurface)this.surface).setKnobLED(i, -1, 0, 0);
            }
        }
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (row == 0) {
            this.resetParameter(index);
        }
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (((HUIControlSurface)this.surface).getExtenderOffset() > 0) {
            return;
        }
        IParameter param = (IParameter)this.device.getParameterBank().getItem(index);
        if (param.doesExist()) {
            param.changeValue(value);
        }
    }

    @Override
    public void resetParameter(int index) {
        if (((HUIControlSurface)this.surface).getExtenderOffset() > 0) {
            return;
        }
        IParameter param = (IParameter)this.device.getParameterBank().getItem(index);
        if (param.doesExist()) {
            param.resetValue();
        }
    }

    @Override
    public void selectPreviousItemPage() {
        this.model.getCursorDevice().selectPrevious();
    }

    @Override
    public void selectNextItemPage() {
        this.model.getCursorDevice().selectNext();
    }
}

