/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler.utils;

import java.util.HashMap;
import java.util.Map;

public enum KnobMode {
    ABSOLUTE("Absolute (push button: Button down > 0, button up = 0)"),
    RELATIVE_TWOS_COMPLEMENT("Relative: Twos Complement (1-64 increment, 127-65 decrement)"),
    RELATIVE_SIGNED_BIT("Relative: Signed Bit (65-127 increment, 1-63 decrement)"),
    RELATIVE_SIGNED_BIT_2("Relative: Signed Bit 2 (1-63 increment, 65-127 decrement)"),
    RELATIVE_OFFSET_BINARY("Relative: Offset Binary (65-127 increment, 63-0 decrement)"),
    ABSOLUTE_TOGGLE("Absolute (toggle button: 1st press > 0, 2nd press = 0)");

    private static final String[] LABELS;
    private static final Map<String, KnobMode> LABEL_KNOBMODE_MAP;
    private final String label;

    private KnobMode(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public static String[] getLabels() {
        return LABELS;
    }

    public static KnobMode lookupByLabel(String label) {
        return LABEL_KNOBMODE_MAP.getOrDefault(label, ABSOLUTE);
    }

    static {
        KnobMode[] values = KnobMode.values();
        LABELS = new String[values.length];
        LABEL_KNOBMODE_MAP = new HashMap<String, KnobMode>(values.length);
        for (int i = 0; i < values.length; ++i) {
            KnobMode.LABELS[i] = values[i].getLabel();
            LABEL_KNOBMODE_MAP.put(LABELS[i], values[i]);
        }
    }
}

