/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.faderfox.ec4.mode;

import de.mossgrabers.controller.faderfox.ec4.EC4Configuration;
import de.mossgrabers.controller.faderfox.ec4.controller.EC4ControlSurface;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.IProject;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.TempoParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class AbstractEC4Mode<B extends IItem>
extends AbstractParameterMode<EC4ControlSurface, EC4Configuration, B> {
    protected final IParameterProvider bottomRowProvider;
    private final PlayCommand<EC4ControlSurface, EC4Configuration> playCommand;
    protected int[] valueCache = new int[16];
    protected boolean isSession = false;
    protected boolean wasSessionUsed = false;

    protected AbstractEC4Mode(String name, EC4ControlSurface surface, IModel model, IBank<B> bank) {
        super(name, surface, model, false, bank, EC4ControlSurface.KNOB_IDS);
        this.playCommand = new PlayCommand(model, surface);
        ITransport transport = model.getTransport();
        this.bottomRowProvider = new CombinedParameterProvider(new FixedParameterProvider(new TempoParameter(model.getValueChanger(), transport, surface)), new FixedParameterProvider(transport.getCrossfadeParameter()), new FixedParameterProvider(model.getProject().getCueVolumeParameter()), new FixedParameterProvider(model.getMasterTrack().getVolumeParameter()));
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (row == 3) {
            ModeManager modeManager = ((EC4ControlSurface)this.surface).getModeManager();
            switch (index) {
                case 0: {
                    if (event == ButtonEvent.DOWN) {
                        if (((EC4ControlSurface)this.surface).isShiftPressed()) {
                            this.model.getTransport().setTempo(120.0);
                            return;
                        }
                        this.wasSessionUsed = false;
                        this.isSession = !this.isSession;
                        break;
                    }
                    if (event != ButtonEvent.UP) break;
                    if (this.isSession && this.wasSessionUsed) {
                        this.isSession = false;
                        break;
                    }
                    this.notifyTotalDisplay("Scene: " + (this.isSession ? "on" : "off"));
                    break;
                }
                case 1: {
                    if (event != ButtonEvent.DOWN) break;
                    if (((EC4ControlSurface)this.surface).isShiftPressed()) {
                        this.model.getTransport().getCrossfadeParameter().resetValue();
                        break;
                    }
                    modeManager.setActive(modeManager.isActive(new Modes[]{Modes.TRACK}) ? Modes.DEVICE_PARAMS : Modes.TRACK);
                    break;
                }
                case 2: {
                    if (event != ButtonEvent.DOWN) {
                        return;
                    }
                    if (((EC4ControlSurface)this.surface).isShiftPressed()) {
                        this.model.getProject().resetCueVolume();
                        return;
                    }
                    if (modeManager.isActive(new Modes[]{Modes.TRACK_DETAILS})) {
                        modeManager.setActive(Modes.TRACK);
                        this.notifyTotalDisplay("Selected Track");
                        break;
                    }
                    modeManager.setActive(Modes.TRACK_DETAILS);
                    this.notifyTotalDisplay("12 Mode");
                    break;
                }
                case 3: {
                    if (((EC4ControlSurface)this.surface).isShiftPressed()) {
                        this.model.getMasterTrack().resetVolume();
                        break;
                    }
                    this.playCommand.execute(event, event == ButtonEvent.DOWN ? 127 : 0);
                    break;
                }
            }
        } else if (this.isSession) {
            this.wasSessionUsed = true;
            IScene scene = (IScene)this.model.getSceneBank().getItem(row * 4 + index);
            if (scene.doesExist()) {
                scene.launch(event == ButtonEvent.DOWN, ((EC4ControlSurface)this.surface).isShiftPressed());
            }
        }
    }

    protected void updateDisplayRow4(ITextDisplay display, List<String[]> totalDisplayInfo, String lastItem) {
        display.setCell(3, 0, "Tmpo").setCell(3, 1, "Xfde").setCell(3, 2, "Cue ").setCell(3, 3, lastItem);
        IMidiOutput output = ((EC4ControlSurface)this.surface).getMidiOutput();
        ITransport transport = this.model.getTransport();
        IProject project = this.model.getProject();
        IMasterTrack masterTrack = this.model.getMasterTrack();
        double tempo = transport.getTempo();
        int tempoAsInt = (int)(tempo * 100.0);
        if (this.valueCache[12] != tempoAsInt && tempoAsInt >= 2000) {
            this.valueCache[12] = tempoAsInt;
            output.sendCCEx(15, 22, (int)(((double)tempoAsInt - 2000.0) / 64600.0 * 127.0));
            this.storeLines(totalDisplayInfo, "Tempo: " + transport.formatTempo(tempo));
        }
        this.updateCache(13, transport.getCrossfade(), totalDisplayInfo, "Crossfade: " + transport.getCrossfadeParameter().getDisplayedValue());
        this.updateCache(14, project.getCueVolume(), totalDisplayInfo, "Cue Vol.: " + project.getCueVolumeStr());
        this.updateCache(15, masterTrack.getVolume(), totalDisplayInfo, "Master: " + masterTrack.getVolumeStr());
    }

    protected void updateCache(int index, int value, List<String[]> totalDisplayInfo, String ... lines) {
        if (this.valueCache[index] == value) {
            return;
        }
        this.valueCache[index] = value;
        IMidiOutput output = ((EC4ControlSurface)this.surface).getMidiOutput();
        output.sendCCEx(15, 10 + index, (int)((double)value * 127.0 / 1024.0));
        this.storeLines(totalDisplayInfo, lines);
    }

    protected void storeLines(List<String[]> totalDisplayInfo, String ... lines) {
        if (lines.length == 4) {
            totalDisplayInfo.add(lines);
        } else {
            Object[] linesNew = new String[4];
            Arrays.fill(linesNew, "");
            System.arraycopy(lines, 0, linesNew, 0, Math.min(3, lines.length));
            totalDisplayInfo.add(lines);
        }
    }

    @Override
    public void onActivate() {
        super.onActivate();
        Arrays.fill(this.valueCache, -1);
    }

    protected void notifyTotalDisplay(String message) {
        ((EC4ControlSurface)this.surface).fillTotalDisplay(Collections.singletonList(new String[]{message, "", "", ""}));
    }
}

