/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.faderfox.ec4.controller;

import de.mossgrabers.controller.faderfox.ec4.EC4Configuration;
import de.mossgrabers.controller.faderfox.ec4.controller.EC4Display;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Arrays;
import java.util.List;

public class EC4ControlSurface
extends AbstractControlSurface<EC4Configuration> {
    public static final int EC4_KNOB_1 = 10;
    public static final int EC4_BUTTON_1 = 30;
    public static final List<ContinuousID> KNOB_IDS = ContinuousID.createSequentialList(ContinuousID.KNOB1, 16);
    private static final byte[] SYSEX_HEADER = new byte[]{-16, 0, 0, 0, 78, 44, 27};
    private static final byte CMD_APP_FUNC = 78;
    private static final byte APP_CMD_SETUP = 40;
    private static final byte APP_CMD_GROUP = 36;
    private static final byte APP_CMD_EXT_KEY = 38;
    private static final byte APP_CMD_SHIFTED_KEY = 42;
    private static final byte APP_CMD_KEY_STATE = 46;
    private final Object notificationLock = new Object();
    private int notificationTimeout = 0;
    private int setupSlot = -1;
    private int selectedSetup = -1;
    private int selectedGroup = -1;
    private boolean isOnline = false;
    private final Object onlineLock = new Object();
    private Modes activeMode;
    private boolean isShiftPressed = false;

    public EC4ControlSurface(IHost host, ColorManager colorManager, EC4Configuration configuration, IMidiOutput output, IMidiInput input) {
        super(host, configuration, colorManager, output, input, null, 430.0, 930.0);
        this.input.setSysexCallback(this::handleSysEx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnline() {
        Object object = this.onlineLock;
        synchronized (object) {
            return this.isOnline;
        }
    }

    public void setSetupSlot(int setupSlot) {
        this.setupSlot = setupSlot;
    }

    public void requestDeviceInfo() {
        this.output.sendSysex(new byte[]{-16, 0, 0, 0, 78, 32, 16, -9});
    }

    private void handleSysEx(String dataStr) {
        byte[] data = StringUtils.asBytes(StringUtils.fromHexStr(dataStr));
        if (Arrays.compareUnsigned(SYSEX_HEADER, 0, SYSEX_HEADER.length, data, 0, SYSEX_HEADER.length) != 0 || data[data.length - 1] != -9) {
            return;
        }
        int contentLength = data.length - SYSEX_HEADER.length - 1;
        byte[] content = new byte[contentLength];
        System.arraycopy(data, SYSEX_HEADER.length, content, 0, contentLength);
        this.handleSysexCommandsController(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSysexCommandsController(byte[] data) {
        byte specialKey = -1;
        byte shiftedKey = -1;
        block10: for (int offset = 0; offset < data.length; offset += 3) {
            if (data[offset] != 78) {
                return;
            }
            byte commandID = data[offset + 1];
            byte value = data[offset + 2];
            switch (commandID) {
                case 40: {
                    this.selectedSetup = value - 16;
                    this.handleOnlineStatus();
                    continue block10;
                }
                case 36: {
                    this.selectedGroup = value - 16;
                    this.handleOnlineStatus();
                    continue block10;
                }
                case 38: {
                    specialKey = value;
                    continue block10;
                }
                case 42: {
                    shiftedKey = value;
                    continue block10;
                }
                case 46: {
                    Object object = this.onlineLock;
                    synchronized (object) {
                        if (this.isOnline) {
                            this.handleSpecialKeys(specialKey, shiftedKey, value);
                        }
                        continue block10;
                    }
                }
            }
        }
    }

    private void handleSpecialKeys(int specialKey, int shiftedKey, byte value) {
        boolean isPressed;
        boolean bl = isPressed = value == 17;
        if (shiftedKey >= 16 && shiftedKey <= 31) {
            ButtonID buttonID = ButtonID.get(ButtonID.PAD1, shiftedKey - 16);
            this.getButton(buttonID).getCommand().execute(isPressed ? ButtonEvent.DOWN : ButtonEvent.UP, 127);
            return;
        }
        if (specialKey == 17) {
            this.isShiftPressed = isPressed;
            this.setKnobSensitivityIsSlow(this.isShiftPressed);
            return;
        }
        if (specialKey >= 18 && specialKey <= 21) {
            this.getButton(ButtonID.get(ButtonID.FOOTSWITCH1, specialKey - 18)).trigger(isPressed ? ButtonEvent.DOWN : ButtonEvent.UP);
        }
    }

    private void handleOnlineStatus() {
        if (this.selectedSetup == this.setupSlot && this.selectedGroup == 0) {
            this.setOnline();
        } else {
            this.setOffline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOffline() {
        Object object = this.onlineLock;
        synchronized (object) {
            if (!this.isOnline) {
                return;
            }
            this.host.println("Going offline...");
            this.isOnline = false;
            this.activeMode = (Modes)((Object)this.modeManager.getActiveID());
            this.modeManager.setActive(Modes.DUMMY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOnline() {
        Object object = this.onlineLock;
        synchronized (object) {
            if (this.isOnline) {
                return;
            }
            this.host.println("Going online...");
            this.isOnline = true;
            this.modeManager.setActive(this.activeMode == null ? Modes.TRACK : this.activeMode);
            this.getTextDisplay().forceFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int value) {
        Object object = this.onlineLock;
        synchronized (object) {
            if (this.isOnline) {
                super.setTrigger(bindType, channel, cc, value);
            }
        }
    }

    @Override
    protected void handleMidi(int status, int data1, int data2) {
    }

    @Override
    public boolean isShiftPressed() {
        return this.isShiftPressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showTotalDisplay() {
        Object object = this.notificationLock;
        synchronized (object) {
            boolean isRunning = this.notificationTimeout > 0;
            this.notificationTimeout = 700;
            if (!isRunning) {
                ((EC4Display)this.getTextDisplay()).setTotalDisplayVisible(true);
                this.host.scheduleTask(this::watch, 100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void watch() {
        Object object = this.notificationLock;
        synchronized (object) {
            this.notificationTimeout -= 100;
            if (this.notificationTimeout <= 0) {
                ((EC4Display)this.getTextDisplay()).setTotalDisplayVisible(false);
            } else {
                this.host.scheduleTask(this::watch, 100L);
            }
        }
    }

    public void fillTotalDisplay(List<String[]> totalDisplayInfo) {
        if (!totalDisplayInfo.isEmpty() && !this.isShuttingDown) {
            this.fillTotalDisplay(totalDisplayInfo.get(0));
        }
    }

    private void fillTotalDisplay(String[] lines) {
        ITextDisplay totalDisplay = this.getTextDisplay(1).clear();
        for (int i = 0; i < lines.length; ++i) {
            totalDisplay.setRow(i, StringUtils.pad(StringUtils.fixASCII(lines[i]), 20));
        }
        totalDisplay.allDone();
        this.showTotalDisplay();
    }

    @Override
    protected void internalShutdown() {
        this.fillTotalDisplay(new String[]{"Please start " + this.host.getName(), "     to play...", "", ""});
        super.internalShutdown();
    }
}

