/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.electra.one;

import de.mossgrabers.framework.controller.DefaultControllerDefinition;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.List;
import java.util.UUID;

public class ElectraOneControllerDefinition
extends DefaultControllerDefinition {
    private static final String ELECTRA_CONTROLLER_ELECTRA_CTRL = "Electra Controller Electra CTRL";

    public ElectraOneControllerDefinition() {
        super(UUID.fromString("24342204-B891-4F62-BC43-8ABA1DE1D690"), "Electra One", "Electra", 2, 2);
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        List<Pair<String[], String[]>> pairs = super.getMidiDiscoveryPairs(os);
        switch (os) {
            case WINDOWS: {
                pairs.add(this.addDeviceDiscoveryPair(new String[]{"Electra Controller", "MIDIIN3 (Electra Controller)"}, new String[]{"Electra Controller", "MIDIOUT3 (Electra Controller)"}));
                for (int i = 2; i < 10; ++i) {
                    String[] portInNames = new String[]{"Electra Controller #" + i, "MIDIIN" + 3 * i + " (Electra Controller)"};
                    String[] portOutNames = new String[]{"Electra Controller #" + i, "MIDIOUT" + 3 * i + " (Electra Controller)"};
                    pairs.add(this.addDeviceDiscoveryPair(portInNames, portOutNames));
                }
                break;
            }
            case MAC: 
            case MAC_ARM: {
                String[] portNamesMac = new String[]{"Electra Controller Electra Port 1", ELECTRA_CONTROLLER_ELECTRA_CTRL};
                pairs.add(this.addDeviceDiscoveryPair(portNamesMac, portNamesMac));
                break;
            }
            default: {
                String[] portNamesLinux = new String[]{"Electra Controller Electra Port", ELECTRA_CONTROLLER_ELECTRA_CTRL};
                pairs.add(this.addDeviceDiscoveryPair(portNamesLinux, portNamesLinux));
            }
        }
        return pairs;
    }
}

