/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.arturia.beatstep.view;

import de.mossgrabers.controller.arturia.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.arturia.beatstep.view.BeatstepView;
import de.mossgrabers.controller.arturia.beatstep.view.TrackEditing;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.parameter.IParameter;
import java.util.Optional;

public class DeviceView
extends AbstractView<BeatstepControlSurface, BeatstepConfiguration>
implements BeatstepView {
    private final TrackEditing extensions;
    private boolean isLayer;

    public DeviceView(BeatstepControlSurface surface, IModel model) {
        super("Device", surface, model);
        this.extensions = new TrackEditing(surface, model);
        this.isLayer = false;
    }

    @Override
    public void onKnob(int index, int value) {
        ICursorDevice cd = this.model.getCursorDevice();
        if (index < 8) {
            this.extensions.onTrackKnob(index, value);
            return;
        }
        ((IParameter)cd.getParameterBank().getItem(index - 8)).changeValue(value);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0 || !this.model.hasSelectedDevice()) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        ILayerBank bank = cd.getLayerBank();
        Optional sel = bank.getSelectedItem();
        switch (note - 36) {
            case 0: {
                cd.toggleEnabledState();
                break;
            }
            case 1: {
                if (this.isLayer) {
                    int index = 0;
                    if (sel.isPresent()) {
                        int idx = ((ILayer)sel.get()).getIndex();
                        index = idx - 1;
                    }
                    if (index < 0) break;
                    ((ILayer)bank.getItem(index)).select();
                    break;
                }
                cd.selectPrevious();
                break;
            }
            case 2: {
                if (this.isLayer) {
                    int index = sel.isEmpty() ? 0 : ((ILayer)sel.get()).getIndex() + 1;
                    ((ILayer)bank.getItem(index > 7 ? 7 : index)).select();
                    break;
                }
                cd.selectNext();
                break;
            }
            case 3: {
                if (!cd.hasLayers()) {
                    return;
                }
                if (this.isLayer) {
                    if (sel.isPresent()) {
                        ((ILayer)sel.get()).enter();
                    }
                } else if (sel.isEmpty()) {
                    ((ILayer)bank.getItem(0)).select();
                }
                this.isLayer = !this.isLayer;
                break;
            }
            case 4: {
                if (this.isLayer) {
                    this.isLayer = false;
                    break;
                }
                if (!cd.isNested()) break;
                cd.selectParent();
                cd.selectChannel();
                this.isLayer = true;
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                cd.getParameterBank().scrollBackwards();
                break;
            }
            case 7: {
                cd.getParameterBank().scrollForwards();
                break;
            }
            default: {
                cd.getParameterBank().getPageBank().selectPage(note - 36 - 8);
            }
        }
    }

    @Override
    public void drawGrid() {
        ICursorDevice cd = this.model.getCursorDevice();
        IParameterPageBank parameterPageBank = cd.getParameterBank().getPageBank();
        int selectedItemIndex = parameterPageBank.getSelectedItemIndex();
        IPadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        for (int i = 0; i < parameterPageBank.getPageSize(); ++i) {
            padGrid.light(44 + i, i == selectedItemIndex ? 16 : 0);
        }
        padGrid.light(36, cd.isEnabled() ? 1 : 0);
        padGrid.light(37, 16);
        padGrid.light(38, 16);
        padGrid.light(39, 1);
        padGrid.light(40, 1);
        padGrid.light(41, 0);
        padGrid.light(42, 16);
        padGrid.light(43, 16);
    }
}

