/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apcmini.view;

import de.mossgrabers.controller.akai.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.utils.ButtonEvent;

public class TrackButtons {
    private final APCminiControlSurface surface;
    private final IModel model;

    public TrackButtons(APCminiControlSurface surface, IModel model) {
        this.surface = surface;
        this.model = model;
    }

    public int getTrackButtonColor(int index) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        int trackState = this.surface.getTrackState();
        switch (trackState) {
            case 0: {
                return this.surface.isPressed(ButtonID.get(ButtonID.ROW_SELECT_1, index)) ? 1 : 0;
            }
            case 1: {
                return ((ITrack)tb.getItem(index)).isSolo() ? 1 : 0;
            }
            case 2: {
                return ((ITrack)tb.getItem(index)).isRecArm() ? 1 : 0;
            }
            case 3: {
                return !((ITrack)tb.getItem(index)).isMute() ? 1 : 0;
            }
            case 4: {
                return ((ITrack)tb.getItem(index)).isSelected() ? 1 : 0;
            }
        }
        return 0;
    }

    public void onSelectTrack(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        int trackState = this.surface.getTrackState();
        ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(index);
        switch (trackState) {
            case 0: {
                track.stop(false);
                break;
            }
            case 1: {
                track.toggleSolo();
                break;
            }
            case 2: {
                track.toggleRecArm();
                break;
            }
            case 3: {
                track.toggleMute();
                break;
            }
            case 4: {
                ((IView)this.surface.getViewManager().getActive()).selectTrack(index);
                break;
            }
        }
    }
}

