/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apcmini;

import de.mossgrabers.controller.akai.apcmini.definition.IAPCminiControllerDefinition;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.view.Views;
import java.util.List;

public class APCminiConfiguration
extends AbstractConfiguration {
    public static final Integer FADER_CTRL = 100;
    public static final Integer SOFT_KEYS = 101;
    public static final Integer PAD_BRIGHTNESS = 102;
    private static final List<String> FADER_CTRL_OPTIONS = List.of("Volume", "Pan", "Send 1", "Send 2", "Send 3", "Send 4", "Send 5", "Send 6", "Send 7", "Send 8", "Device");
    private static final List<String> BRIGHTNESS_OPTIONS = List.of("10%", "25%", "50%", "65%", "75%", "90%", "100%");
    public static final List<String> SOFT_KEYS_OPTIONS = List.of("Clip Stop", "Solo", "Rec Arm", "Mute", "Select");
    private static final Views[] PREFERRED_NOTE_VIEWS = new Views[]{Views.PLAY, Views.DRUM, Views.SEQUENCER, Views.RAINDROPS};
    private final IAPCminiControllerDefinition definition;
    private String faderCtrl = FADER_CTRL_OPTIONS.get(0);
    private String softKeys = SOFT_KEYS_OPTIONS.get(0);
    private IEnumSetting faderCtrlSetting;
    private IEnumSetting softKeysSetting;
    private int padBrightness = 4;

    public APCminiConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes, IAPCminiControllerDefinition definition) {
        super(host, valueChanger, arpeggiatorModes);
        this.definition = definition;
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        if (this.definition.hasBrightness()) {
            IEnumSetting padBrightnessSetting = globalSettings.getEnumSetting("Pad Brightness", "Hardware Setup", BRIGHTNESS_OPTIONS, BRIGHTNESS_OPTIONS.get(this.padBrightness));
            padBrightnessSetting.addValueObserver(value -> {
                this.padBrightness = APCminiConfiguration.lookupIndex(BRIGHTNESS_OPTIONS, value);
                this.notifyObservers(PAD_BRIGHTNESS);
            });
        }
        this.activateScaleSetting(documentSettings);
        this.activateScaleBaseSetting(documentSettings);
        this.activateScaleInScaleSetting(documentSettings);
        this.activateScaleLayoutSetting(documentSettings);
        this.activateQuantizeAmountSetting(globalSettings);
        this.activateStartupViewSetting(globalSettings, PREFERRED_NOTE_VIEWS);
        this.activateStartWithSessionViewSetting(globalSettings);
        this.activateShowPlayedChordsSetting(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateSelectClipOnLaunchSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.faderCtrlSetting = globalSettings.getEnumSetting("Fader Ctrl", "Button Control", FADER_CTRL_OPTIONS, this.faderCtrl);
        this.faderCtrlSetting.addValueObserver(value -> {
            this.faderCtrl = value;
            this.notifyObservers(FADER_CTRL);
        });
        this.softKeysSetting = globalSettings.getEnumSetting("Soft Keys", "Button Control", SOFT_KEYS_OPTIONS, this.softKeys);
        this.softKeysSetting.addValueObserver(value -> {
            this.softKeys = value;
            this.notifyObservers(SOFT_KEYS);
        });
        this.isSettingActive.add(FADER_CTRL);
        this.isSettingActive.add(SOFT_KEYS);
    }

    public void setFaderCtrl(String faderCtrl) {
        this.faderCtrlSetting.set(faderCtrl);
    }

    public void setSoftKeys(String softKeys) {
        this.softKeysSetting.set(softKeys);
    }

    public String getFaderCtrl() {
        return this.faderCtrl;
    }

    public String getSoftKeys() {
        return this.softKeys;
    }

    public int getPadBrightness() {
        return this.padBrightness;
    }
}

