/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.mode;

import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.controller.akai.apc.mode.BaseMode;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;

public class BrowserMode
extends BaseMode<IItem> {
    private static final int[] COLUMN_ORDER = new int[]{0, 6, 1, 2, 3, 4, 5};
    private int lastValue;

    public BrowserMode(APCControlSurface surface, IModel model) {
        super("Browser", surface, model, 3, null);
    }

    @Override
    public void setValue(int index, int value) {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        int diff = value - this.lastValue;
        boolean isLeft = value == 0 || diff < 0;
        this.lastValue = value;
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (isLeft) {
                    browser.selectPreviousFilterItem(COLUMN_ORDER[index]);
                    break;
                }
                browser.selectNextFilterItem(COLUMN_ORDER[index]);
                break;
            }
            case 7: {
                if (isLeft) {
                    browser.selectPreviousResult();
                    break;
                }
                browser.selectNextResult();
                break;
            }
        }
    }

    @Override
    public void selectPreviousItemPage() {
        this.model.getBrowser().previousContentType();
    }

    @Override
    public void selectNextItemPage() {
        this.model.getBrowser().nextContentType();
    }

    @Override
    public boolean hasPreviousItem() {
        return this.model.getBrowser().hasPreviousContentType();
    }

    @Override
    public boolean hasNextItem() {
        return this.model.getBrowser().hasNextContentType();
    }

    @Override
    public boolean hasPreviousItemPage() {
        return this.hasPreviousItem();
    }

    @Override
    public boolean hasNextItemPage() {
        return this.hasNextItem();
    }
}

