/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.device;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.bank.IDeviceBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Optional;

public class DeviceParamsMode
extends BaseMode<IParameter> {
    private static final String[] MENU = new String[]{"On", "Parameters", "Expanded", "Chains", "Banks", "Pin Device", "Window", "Up"};
    protected final String[] hostMenu = new String[MENU.length];
    protected boolean showDevices;

    public DeviceParamsMode(PushControlSurface surface, IModel model) {
        super("Parameters", surface, model, model.getCursorDevice().getParameterBank());
        this.setParameterProvider(new BankParameterProvider(this.model.getCursorDevice().getParameterBank()));
        this.setShowDevices(true);
        System.arraycopy(MENU, 0, this.hostMenu, 0, MENU.length);
        IHost host = this.model.getHost();
        if (!host.supports(Capability.HAS_PARAMETER_PAGE_SECTION)) {
            this.hostMenu[1] = "";
        }
        if (!host.supports(Capability.HAS_PINNING)) {
            this.hostMenu[5] = "";
        }
        if (!host.supports(Capability.HAS_SLOT_CHAINS)) {
            this.hostMenu[3] = "";
        }
    }

    public final void setShowDevices(boolean enable) {
        this.showDevices = enable;
    }

    public boolean isShowDevices() {
        return this.showDevices;
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        ICursorDevice cd = this.model.getCursorDevice();
        IParameter param = (IParameter)cd.getParameterBank().getItem(index);
        if (isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            param.resetValue();
        }
        param.touchValue(isTouched);
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            return;
        }
        if (event == ButtonEvent.UP) {
            ICursorDevice cd = this.model.getCursorDevice();
            if (!cd.doesExist()) {
                return;
            }
            if (!this.showDevices) {
                cd.getParameterBank().getPageBank().selectPage(index);
                return;
            }
            if (this.isButtonCombination(ButtonID.DUPLICATE)) {
                cd.duplicate();
                return;
            }
            if (this.isButtonCombination(ButtonID.DELETE)) {
                ((IDevice)cd.getDeviceBank().getItem(index)).remove();
                return;
            }
            if (this.isButtonCombination(ButtonID.MUTE)) {
                ((IDevice)cd.getDeviceBank().getItem(index)).toggleEnabledState();
                return;
            }
            if (cd.getIndex() != index) {
                ((IDevice)cd.getDeviceBank().getItem(index)).select();
                return;
            }
            ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
            if (!cd.hasLayers()) {
                ((DeviceParamsMode)modeManager.get(Modes.DEVICE_PARAMS)).setShowDevices(false);
                return;
            }
            Optional layer = cd.getLayerBank().getSelectedItem();
            if (layer.isEmpty()) {
                ((ILayer)cd.getLayerBank().getItem(0)).select();
            }
            modeManager.setActive(((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getCurrentLayerMixMode());
            return;
        }
        ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.get(ButtonID.ROW1_1, index));
        this.moveUp();
    }

    protected void moveUp() {
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.DEVICE_CHAINS})) {
            modeManager.setActive(Modes.DEVICE_PARAMS);
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.doesExist()) {
            ((PushControlSurface)this.surface).getButton(ButtonID.TRACK).trigger(ButtonEvent.DOWN);
            return;
        }
        DeviceParamsMode deviceParamsMode = (DeviceParamsMode)modeManager.get(Modes.DEVICE_PARAMS);
        if (!deviceParamsMode.isShowDevices()) {
            deviceParamsMode.setShowDevices(true);
            return;
        }
        if (cd.isNested()) {
            cd.selectParent();
            this.model.getHost().scheduleTask(() -> {
                if (cd.hasLayers()) {
                    modeManager.setActive(((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getCurrentLayerMixMode());
                } else {
                    modeManager.setActive(Modes.DEVICE_PARAMS);
                }
                deviceParamsMode.setShowDevices(false);
                cd.selectChannel();
            }, 300L);
            return;
        }
        if (this.model.isCursorDeviceOnMasterTrack()) {
            ((PushControlSurface)this.surface).getButton(ButtonID.MASTERTRACK).trigger(ButtonEvent.DOWN);
        } else {
            ((PushControlSurface)this.surface).getButton(ButtonID.TRACK).trigger(ButtonEvent.DOWN);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        ICursorDevice cd = this.model.getCursorDevice();
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            if (!cd.doesExist()) {
                return super.getButtonColor(buttonID);
            }
            int selectedColor = this.colorManager.getColorIndex("PUSH_ORANGE_HI");
            int existsColor = this.colorManager.getColorIndex("PUSH_YELLOW_LO");
            int offColor = this.colorManager.getColorIndex("PUSH_BLACK");
            if (this.showDevices) {
                IDeviceBank bank = cd.getDeviceBank();
                if (!((IDevice)bank.getItem(index)).doesExist()) {
                    return offColor;
                }
                return index == cd.getIndex() ? selectedColor : existsColor;
            }
            IParameterPageBank bank = cd.getParameterBank().getPageBank();
            int selectedItemIndex = bank.getSelectedItemIndex();
            if (((String)bank.getItem(index)).isEmpty()) {
                return offColor;
            }
            return index == selectedItemIndex ? selectedColor : existsColor;
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            int white;
            int n = white = this.isPushModern ? 3 : 3;
            if (!cd.doesExist()) {
                return index == 7 ? white : super.getButtonColor(buttonID);
            }
            int green = this.isPushModern ? 22 : 22;
            int grey = this.isPushModern ? 1 : 1;
            int orange = this.isPushModern ? 65 : 65;
            int off = this.isPushModern ? 0 : 0;
            int turquoise = this.isPushModern ? 31 : 31;
            switch (index) {
                case 0: {
                    return cd.isEnabled() ? green : grey;
                }
                case 1: {
                    return cd.isParameterPageSectionVisible() ? orange : white;
                }
                case 2: {
                    return cd.isExpanded() ? orange : white;
                }
                case 3: {
                    return ((PushControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.DEVICE_CHAINS}) ? orange : white;
                }
                case 4: {
                    return this.showDevices ? white : orange;
                }
                case 5: {
                    if (!this.model.getHost().supports(Capability.HAS_PINNING)) {
                        return off;
                    }
                    return cd.isPinned() ? turquoise : grey;
                }
                case 6: {
                    return cd.isWindowOpen() ? turquoise : grey;
                }
            }
            return white;
        }
        return super.getButtonColor(buttonID);
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ICursorDevice device = this.model.getCursorDevice();
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        switch (index) {
            case 0: {
                if (!device.doesExist()) break;
                device.toggleEnabledState();
                break;
            }
            case 1: {
                if (!device.doesExist()) break;
                device.toggleParameterPageSectionVisible();
                break;
            }
            case 2: {
                if (!device.doesExist()) break;
                device.toggleExpanded();
                break;
            }
            case 3: {
                if (!this.model.getHost().supports(Capability.HAS_SLOT_CHAINS)) {
                    return;
                }
                if (modeManager.isActive(new Modes[]{Modes.DEVICE_CHAINS})) {
                    modeManager.setActive(Modes.DEVICE_PARAMS);
                    break;
                }
                modeManager.setActive(Modes.DEVICE_CHAINS);
                break;
            }
            case 4: {
                if (!device.doesExist()) {
                    return;
                }
                if (!modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS})) {
                    modeManager.setActive(Modes.DEVICE_PARAMS);
                }
                this.setShowDevices(!this.showDevices);
                break;
            }
            case 5: {
                if (!device.doesExist()) break;
                device.togglePinned();
                break;
            }
            case 6: {
                if (!device.doesExist()) break;
                device.toggleWindowOpen();
                break;
            }
            case 7: {
                this.moveUp();
                break;
            }
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        ICursorDevice cd = this.model.getCursorDevice();
        if (!this.checkExists1(display, cd)) {
            return;
        }
        IParameterBank parameterBank = cd.getParameterBank();
        for (int i = 0; i < 8; ++i) {
            IParameter param = (IParameter)parameterBank.getItem(i);
            display.setCell(0, i, param.doesExist() ? StringUtils.fixASCII(param.getName()) : "").setCell(1, i, StringUtils.fixASCII(param.getDisplayedValue(8)));
        }
        display.setBlock(2, 0, "Selected Device:").setBlock(2, 1, cd.getName());
        if (this.showDevices) {
            IDeviceBank deviceBank = cd.getDeviceBank();
            for (int i = 0; i < 8; ++i) {
                IDevice device = (IDevice)deviceBank.getItem(i);
                StringBuilder sb = new StringBuilder();
                if (device.doesExist()) {
                    if (i == cd.getIndex()) {
                        sb.append(Push1Display.SELECT_ARROW);
                    }
                    if (!device.isEnabled()) {
                        sb.append(Push1Display.DIVISION);
                    }
                    sb.append(device.getName());
                }
                display.setCell(3, i, sb.toString());
            }
            return;
        }
        IParameterPageBank bank = parameterBank.getPageBank();
        int selectedItemIndex = bank.getSelectedItemIndex();
        for (int i = 0; i < bank.getPageSize(); ++i) {
            String item = (String)bank.getItem(i);
            String selectedStr = i == selectedItemIndex ? Push1Display.SELECT_ARROW : "";
            display.setCell(3, i, (String)(item.isEmpty() ? "" : selectedStr + item));
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        ICursorDevice cd = this.model.getCursorDevice();
        if (!this.checkExists2(display, cd)) {
            return;
        }
        String channelColor = this.model.getCurrentTrackBank().getSelectedChannelColorEntry();
        ColorEx bottomMenuColor = DAWColor.getColorEntry(channelColor);
        ColorEx colorBackground = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getColorBackground();
        IDeviceBank deviceBank = cd.getDeviceBank();
        IParameterBank parameterBank = cd.getParameterBank();
        IParameterPageBank parameterPageBank = parameterBank.getPageBank();
        int selectedPage = parameterPageBank.getSelectedItemIndex();
        boolean hasPinning = this.model.getHost().supports(Capability.HAS_PINNING);
        IValueChanger valueChanger = this.model.getValueChanger();
        for (int i = 0; i < parameterBank.getPageSize(); ++i) {
            boolean isBottomMenuOn;
            String bottomMenu;
            String bottomMenuIcon;
            boolean isTopMenuOn = this.getTopMenuEnablement(cd, hasPinning, i);
            ColorEx color = bottomMenuColor;
            if (this.showDevices) {
                IDevice device = (IDevice)deviceBank.getItem(i);
                bottomMenuIcon = device.getName();
                bottomMenu = device.doesExist() ? device.getName(12) : "";
                boolean bl = isBottomMenuOn = i == cd.getIndex();
                if (!device.isEnabled()) {
                    color = colorBackground;
                }
            } else {
                bottomMenuIcon = cd.getName();
                bottomMenu = StringUtils.limit((String)parameterPageBank.getItem(i), 12);
                isBottomMenuOn = i == selectedPage;
            }
            IParameter param = (IParameter)parameterBank.getItem(i);
            boolean exists = param.doesExist();
            String parameterName = exists ? param.getName(9) : "";
            int parameterValue = valueChanger.toDisplayValue(exists ? param.getValue() : 0);
            String parameterValueStr = exists ? param.getDisplayedValue(8) : "";
            boolean parameterIsActive = this.isKnobTouched(i);
            int parameterModulatedValue = valueChanger.toDisplayValue(exists ? param.getModulatedValue() : -1);
            display.addParameterElement(this.hostMenu[i], isTopMenuOn, bottomMenu, bottomMenuIcon, color, isBottomMenuOn, parameterName, parameterValue, parameterValueStr, parameterIsActive, parameterModulatedValue);
        }
    }

    @Override
    public void selectPreviousItem() {
        if (this.showDevices) {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            cursorDevice.getDeviceBank().selectPreviousItem();
            return;
        }
        super.selectPreviousItem();
    }

    @Override
    public void selectNextItem() {
        if (this.showDevices) {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            cursorDevice.getDeviceBank().selectNextItem();
            return;
        }
        super.selectNextItem();
    }

    @Override
    public void selectPreviousItemPage() {
        if (this.showDevices) {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            if (((PushControlSurface)this.surface).isShiftPressed()) {
                cursorDevice.swapWithPrevious();
            } else {
                cursorDevice.getDeviceBank().selectPreviousPage();
            }
            return;
        }
        super.selectPreviousItemPage();
    }

    @Override
    public void selectNextItemPage() {
        if (this.showDevices) {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            if (((PushControlSurface)this.surface).isShiftPressed()) {
                cursorDevice.swapWithNext();
            } else {
                cursorDevice.getDeviceBank().selectNextPage();
            }
            return;
        }
        super.selectNextItemPage();
    }

    @Override
    public boolean hasPreviousItem() {
        if (this.showDevices) {
            return this.model.getCursorDevice().getDeviceBank().canScrollBackwards();
        }
        return super.hasPreviousItem();
    }

    @Override
    public boolean hasNextItem() {
        if (this.showDevices) {
            return this.model.getCursorDevice().getDeviceBank().canScrollForwards();
        }
        return super.hasNextItem();
    }

    @Override
    public boolean hasPreviousItemPage() {
        if (this.showDevices) {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            if (((PushControlSurface)this.surface).isShiftPressed()) {
                return cursorDevice.getIndex() > 0;
            }
            return cursorDevice.getDeviceBank().canScrollPageBackwards();
        }
        return super.hasPreviousItemPage();
    }

    @Override
    public boolean hasNextItemPage() {
        if (this.showDevices) {
            ICursorDevice cursorDevice = this.model.getCursorDevice();
            if (((PushControlSurface)this.surface).isShiftPressed()) {
                return cursorDevice.getIndex() < 7;
            }
            return cursorDevice.getDeviceBank().canScrollPageForwards();
        }
        return super.hasNextItemPage();
    }

    protected boolean checkExists1(ITextDisplay display, ICursorDevice cd) {
        if (cd.doesExist()) {
            return true;
        }
        display.setBlock(1, 0, "           Select").setBlock(1, 1, "a device or press").setBlock(1, 2, "'Add Effect'...  ").allDone();
        return false;
    }

    protected boolean checkExists2(IGraphicDisplay display, ICursorDevice cd) {
        if (cd.doesExist()) {
            return true;
        }
        for (int i = 0; i < 8; ++i) {
            display.addOptionElement(i == 2 ? "Please select a device or press 'Add Device'..." : "", i == 7 ? "Up" : "", true, "", "", false, true);
        }
        return false;
    }

    protected boolean getTopMenuEnablement(ICursorDevice cd, boolean hasPinning, int index) {
        switch (index) {
            case 0: {
                return cd.isEnabled();
            }
            case 1: {
                return cd.isParameterPageSectionVisible();
            }
            case 2: {
                return cd.isExpanded();
            }
            case 3: {
                return ((PushControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.DEVICE_CHAINS});
            }
            case 4: {
                return !((PushControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.DEVICE_CHAINS}) && !this.showDevices;
            }
            case 5: {
                return hasPinning && cd.isPinned();
            }
            case 6: {
                return cd.isWindowOpen();
            }
            case 7: {
                return true;
            }
        }
        return false;
    }
}

