/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.AutomationMode;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.utils.ButtonEvent;

public class AutomationSelectionMode
extends BaseMode<IItem> {
    private final AutomationMode[] automationWriteModes;

    public AutomationSelectionMode(PushControlSurface surface, IModel model) {
        super("Automation", surface, model);
        this.automationWriteModes = this.model.getTransport().getAutomationWriteModes();
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        AutomationMode writeMode = this.model.getTransport().getAutomationWriteMode();
        display.setBlock(1, 0, "Automation Mode:");
        for (int i = 0; i < this.automationWriteModes.length; ++i) {
            display.setCell(3, i, (this.automationWriteModes[i] == writeMode ? Push1Display.SELECT_ARROW : "") + this.automationWriteModes[i].getLabel());
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        AutomationMode writeMode = this.model.getTransport().getAutomationWriteMode();
        for (int i = 0; i < 8; ++i) {
            display.addOptionElement("", "", false, i == 0 ? "Automation Mode" : "", i < this.automationWriteModes.length ? this.automationWriteModes[i].getLabel() : "", i < this.automationWriteModes.length && this.automationWriteModes[i] == writeMode, false);
        }
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index < this.automationWriteModes.length) {
            this.model.getTransport().setAutomationWriteMode(this.automationWriteModes[index]);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            AutomationMode writeMode = this.model.getTransport().getAutomationWriteMode();
            if (index < this.automationWriteModes.length) {
                return this.colorManager.getColorIndex(this.automationWriteModes[index] == writeMode ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON");
            }
        }
        return super.getButtonColor(buttonID);
    }
}

