/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.controller;

import de.mossgrabers.controller.ableton.push.PushVersion;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorIndexException;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.DAWColor;
import java.util.HashSet;
import java.util.Set;

public class PushColorManager
extends ColorManager {
    public static final String PUSH_BUTTON_STATE_REC_ON = "PUSH_BUTTON_STATE_REC_ON";
    public static final String PUSH_BUTTON_STATE_REC_HI = "PUSH_BUTTON_STATE_REC_HI";
    public static final String PUSH_BUTTON_STATE_OVR_ON = "PUSH_BUTTON_STATE_OVR_ON";
    public static final String PUSH_BUTTON_STATE_OVR_HI = "PUSH_BUTTON_STATE_OVR_HI";
    public static final String PUSH_BUTTON_STATE_PLAY_ON = "PUSH_BUTTON_STATE_PLAY_ON";
    public static final String PUSH_BUTTON_STATE_PLAY_HI = "PUSH_BUTTON_STATE_PLAY_HI";
    public static final String PUSH_BUTTON_STATE_MUTE_ON = "PUSH_BUTTON_STATE_MUTE_ON";
    public static final String PUSH_BUTTON_STATE_MUTE_HI = "PUSH_BUTTON_STATE_MUTE_HI";
    public static final String PUSH_BUTTON_STATE_SOLO_ON = "PUSH_BUTTON_STATE_SOLO_ON";
    public static final String PUSH_BUTTON_STATE_SOLO_HI = "PUSH_BUTTON_STATE_SOLO_HI";
    public static final String PUSH_BUTTON_STATE_STOP_ON = "PUSH_BUTTON_STATE_STOP_ON";
    public static final String PUSH_BUTTON_STATE_STOP_HI = "PUSH_BUTTON_STATE_STOP_HI";
    public static final String NOTE_REPEAT_PERIOD_OFF = "NOTE_REPEAT_PERIOD_OFF";
    public static final String NOTE_REPEAT_PERIOD_HI = "NOTE_REPEAT_PERIOD_HI";
    public static final String NOTE_REPEAT_LENGTH_OFF = "NOTE_REPEAT_LENGTH_OFF";
    public static final String NOTE_REPEAT_LENGTH_HI = "NOTE_REPEAT_LENGTH_HI";
    public static final String PUSH_BUTTON_STATE_MASTER_ON = "PUSH_BUTTON_STATE_MASTER_ON";
    public static final String PUSH_BUTTON_STATE_MASTER_HI = "PUSH_BUTTON_STATE_MASTER_HI";
    public static final String PUSH_BUTTON_STATE_LOCK_ON = "PUSH_BUTTON_STATE_LOCK_ON";
    public static final String PUSH_BUTTON_STATE_LOCK_HI = "PUSH_BUTTON_STATE_LOCK_HI";
    public static final String PUSH_BUTTON_STATE_INSERT_SCENE_ON = "PUSH_BUTTON_STATE_INSERT_SCENE_ON";
    public static final String PUSH_BUTTON_STATE_INSERT_SCENE_HI = "PUSH_BUTTON_STATE_INSERT_SCENE_HI";
    protected static final int[][] DEFAULT_PALETTE = new int[][]{{0, 0, 0}, {30, 30, 30}, {127, 127, 127}, {255, 255, 255}, {255, 76, 76}, {255, 0, 0}, {89, 0, 0}, {25, 0, 0}, {255, 189, 108}, {255, 84, 0}, {89, 29, 0}, {39, 27, 0}, {255, 255, 76}, {255, 255, 0}, {89, 89, 0}, {25, 25, 0}, {136, 255, 76}, {84, 255, 0}, {29, 89, 0}, {20, 43, 0}, {76, 255, 76}, {0, 255, 0}, {0, 89, 0}, {0, 25, 0}, {76, 255, 94}, {0, 255, 25}, {0, 89, 13}, {0, 25, 2}, {76, 255, 136}, {0, 255, 85}, {0, 89, 29}, {0, 31, 18}, {76, 255, 183}, {0, 255, 153}, {0, 89, 53}, {0, 25, 18}, {76, 195, 255}, {0, 169, 255}, {0, 65, 82}, {0, 16, 25}, {76, 136, 255}, {0, 85, 255}, {0, 29, 89}, {0, 8, 25}, {76, 76, 255}, {0, 0, 255}, {0, 0, 89}, {0, 0, 25}, {135, 76, 255}, {84, 0, 255}, {25, 0, 100}, {15, 0, 48}, {255, 76, 255}, {255, 0, 255}, {89, 0, 89}, {25, 0, 25}, {255, 76, 135}, {255, 0, 84}, {89, 0, 29}, {34, 0, 19}, {255, 21, 0}, {153, 53, 0}, {121, 81, 0}, {67, 100, 0}, {3, 57, 0}, {0, 87, 53}, {0, 84, 127}, {0, 0, 255}, {0, 69, 79}, {37, 0, 204}, {127, 127, 127}, {32, 32, 32}, {255, 0, 0}, {189, 255, 45}, {175, 237, 6}, {100, 255, 9}, {16, 139, 0}, {0, 255, 135}, {0, 169, 255}, {0, 42, 255}, {63, 0, 255}, {122, 0, 255}, {178, 26, 125}, {64, 33, 0}, {255, 74, 0}, {136, 225, 6}, {114, 255, 21}, {0, 255, 0}, {59, 255, 38}, {89, 255, 113}, {56, 255, 204}, {91, 138, 255}, {49, 81, 198}, {135, 127, 233}, {211, 29, 255}, {255, 0, 93}, {255, 127, 0}, {185, 176, 0}, {144, 255, 0}, {131, 93, 7}, {57, 43, 0}, {20, 76, 16}, {13, 80, 56}, {21, 21, 42}, {22, 32, 90}, {105, 60, 28}, {168, 0, 10}, {222, 81, 61}, {216, 106, 28}, {255, 225, 38}, {158, 225, 47}, {103, 181, 15}, {30, 30, 48}, {220, 255, 107}, {128, 255, 189}, {154, 153, 255}, {142, 102, 255}, {64, 64, 64}, {117, 117, 117}, {224, 255, 255}, {160, 0, 0}, {53, 0, 0}, {26, 208, 0}, {7, 66, 0}, {185, 176, 0}, {63, 49, 0}, {179, 95, 0}, {75, 21, 2}};
    public static final int PUSH2_COLOR2_BLACK = 0;
    public static final int PUSH2_COLOR2_GREY_LO = 1;
    public static final int PUSH2_COLOR2_GREY_MD = 103;
    public static final int PUSH2_COLOR2_GREY_LT = 2;
    public static final int PUSH2_COLOR2_WHITE = 3;
    public static final int PUSH2_COLOR2_ROSE = 4;
    public static final int PUSH2_COLOR2_RED_HI = 5;
    public static final int PUSH2_COLOR2_RED = 6;
    public static final int PUSH2_COLOR2_RED_LO = 7;
    public static final int PUSH2_COLOR2_RED_AMBER = 8;
    public static final int PUSH2_COLOR2_AMBER_HI = 9;
    public static final int PUSH2_COLOR2_AMBER = 10;
    public static final int PUSH2_COLOR2_AMBER_LO = 11;
    public static final int PUSH2_COLOR2_AMBER_YELLOW = 12;
    public static final int PUSH2_COLOR2_YELLOW_HI = 13;
    public static final int PUSH2_COLOR2_YELLOW = 14;
    public static final int PUSH2_COLOR2_YELLOW_LO = 15;
    public static final int PUSH2_COLOR2_YELLOW_LIME = 16;
    public static final int PUSH2_COLOR2_LIME_HI = 17;
    public static final int PUSH2_COLOR2_LIME = 18;
    public static final int PUSH2_COLOR2_LIME_LO = 19;
    public static final int PUSH2_COLOR2_LIME_GREEN = 20;
    public static final int PUSH2_COLOR2_GREEN_HI = 21;
    public static final int PUSH2_COLOR2_GREEN = 22;
    public static final int PUSH2_COLOR2_GREEN_LO = 23;
    public static final int PUSH2_COLOR2_GREEN_SPRING = 24;
    public static final int PUSH2_COLOR2_SPRING_HI = 25;
    public static final int PUSH2_COLOR2_SPRING = 26;
    public static final int PUSH2_COLOR2_SPRING_LO = 27;
    public static final int PUSH2_COLOR2_SPRING_TURQUOISE = 28;
    public static final int PUSH2_COLOR2_TURQUOISE_LO = 29;
    public static final int PUSH2_COLOR2_TURQUOISE = 30;
    public static final int PUSH2_COLOR2_TURQUOISE_HI = 31;
    public static final int PUSH2_COLOR2_TURQUOISE_CYAN = 32;
    public static final int PUSH2_COLOR2_CYAN_HI = 33;
    public static final int PUSH2_COLOR2_CYAN = 34;
    public static final int PUSH2_COLOR2_CYAN_LO = 35;
    public static final int PUSH2_COLOR2_CYAN_SKY = 36;
    public static final int PUSH2_COLOR2_SKY_HI = 37;
    public static final int PUSH2_COLOR2_SKY = 38;
    public static final int PUSH2_COLOR2_SKY_LO = 39;
    public static final int PUSH2_COLOR2_SKY_OCEAN = 40;
    public static final int PUSH2_COLOR2_OCEAN_HI = 41;
    public static final int PUSH2_COLOR2_OCEAN = 42;
    public static final int PUSH2_COLOR2_OCEAN_LO = 43;
    public static final int PUSH2_COLOR2_OCEAN_BLUE = 44;
    public static final int PUSH2_COLOR2_BLUE_HI = 45;
    public static final int PUSH2_COLOR2_BLUE = 46;
    public static final int PUSH2_COLOR2_BLUE_LO = 47;
    public static final int PUSH2_COLOR2_BLUE_ORCHID = 48;
    public static final int PUSH2_COLOR2_ORCHID_HI = 49;
    public static final int PUSH2_COLOR2_ORCHID = 50;
    public static final int PUSH2_COLOR2_ORCHID_LO = 51;
    public static final int PUSH2_COLOR2_ORCHID_MAGENTA = 52;
    public static final int PUSH2_COLOR2_MAGENTA_HI = 53;
    public static final int PUSH2_COLOR2_MAGENTA = 54;
    public static final int PUSH2_COLOR2_MAGENTA_LO = 55;
    public static final int PUSH2_COLOR2_MAGENTA_PINK = 56;
    public static final int PUSH2_COLOR2_PINK_HI = 57;
    public static final int PUSH2_COLOR2_PINK = 58;
    public static final int PUSH2_COLOR2_PINK_LO = 59;
    public static final int PUSH2_COLOR2_SILVER = 118;
    public static final int PUSH2_COLOR2_ORANGE = 65;
    public static final int PUSH2_COLOR2_ORANGE_LIGHT = 3;
    public static final int PUSH2_COLOR2_LIGHT_BROWN = 69;
    public static final int PUSH2_COLOR_BLACK = 0;
    public static final int PUSH2_COLOR_RED_LO = 7;
    public static final int PUSH2_COLOR_RED_LO_SBLINK = 2;
    public static final int PUSH2_COLOR_RED_LO_FBLINK = 3;
    public static final int PUSH2_COLOR_RED_HI = 5;
    public static final int PUSH2_COLOR_RED_HI_SBLINK = 5;
    public static final int PUSH2_COLOR_RED_HI_FBLINK = 6;
    public static final int PUSH2_COLOR_ORANGE_LO = 11;
    public static final int PUSH2_COLOR_ORANGE_LO_SBLINK = 8;
    public static final int PUSH2_COLOR_ORANGE_LO_FBLINK = 9;
    public static final int PUSH2_COLOR_ORANGE_HI = 9;
    public static final int PUSH2_COLOR_ORANGE_HI_SBLINK = 11;
    public static final int PUSH2_COLOR_ORANGE_HI_FBLINK = 12;
    public static final int PUSH2_COLOR_YELLOW_LO = 15;
    public static final int PUSH2_COLOR_YELLOW_LO_SBLINK = 14;
    public static final int PUSH2_COLOR_YELLOW_LO_FBLINK = 15;
    public static final int PUSH2_COLOR_YELLOW_MD = 13;
    public static final int PUSH2_COLOR_YELLOW_MD_SBLINK = 17;
    public static final int PUSH2_COLOR_YELLOW_MD_FBLINK = 18;
    public static final int PUSH2_COLOR_GREEN_LO = 23;
    public static final int PUSH2_COLOR_GREEN_LO_SBLINK = 20;
    public static final int PUSH2_COLOR_GREEN_LO_FBLINK = 21;
    public static final int PUSH2_COLOR_GREEN_HI = 21;
    public static final int PUSH2_COLOR_GREEN_HI_SBLINK = 23;
    public static final int PUSH2_COLOR_GREEN_HI_FBLINK = 24;
    public static final int PUSH2_COLOR_SCENE_RED = 6;
    public static final int PUSH2_COLOR_SCENE_RED_BLINK = 2;
    public static final int PUSH2_COLOR_SCENE_RED_BLINK_FAST = 3;
    public static final int PUSH2_COLOR_SCENE_RED_HI = 5;
    public static final int PUSH2_COLOR_SCENE_RED_HI_BLINK = 5;
    public static final int PUSH2_COLOR_SCENE_RED_HI_BLINK_FAST = 6;
    public static final int PUSH2_COLOR_SCENE_ORANGE = 10;
    public static final int PUSH2_COLOR_SCENE_ORANGE_BLINK = 8;
    public static final int PUSH2_COLOR_SCENE_ORANGE_BLINK_FAST = 9;
    public static final int PUSH2_COLOR_SCENE_ORANGE_HI = 9;
    public static final int PUSH2_COLOR_SCENE_ORANGE_HI_BLINK = 11;
    public static final int PUSH2_COLOR_SCENE_ORANGE_HI_BLINK_FAST = 12;
    public static final int PUSH2_COLOR_SCENE_YELLOW = 14;
    public static final int PUSH2_COLOR_SCENE_YELLOW_BLINK = 14;
    public static final int PUSH2_COLOR_SCENE_YELLOW_BLINK_FAST = 15;
    public static final int PUSH2_COLOR_SCENE_YELLOW_HI = 13;
    public static final int PUSH2_COLOR_SCENE_YELLOW_HI_BLINK = 17;
    public static final int PUSH2_COLOR_SCENE_YELLOW_HI_BLINK_FAST = 18;
    public static final int PUSH2_COLOR_SCENE_GREEN = 22;
    public static final int PUSH2_COLOR_SCENE_GREEN_BLINK = 20;
    public static final int PUSH2_COLOR_SCENE_GREEN_BLINK_FAST = 21;
    public static final int PUSH2_COLOR_SCENE_GREEN_HI = 21;
    public static final int PUSH2_COLOR_SCENE_GREEN_HI_BLINK = 23;
    public static final int PUSH2_COLOR_SCENE_GREEN_HI_BLINK_FAST = 24;
    public static final int PUSH2_COLOR_SCENE_WHITE = 60;
    public static final int PUSH1_COLOR_BLACK = 0;
    public static final int PUSH1_COLOR_RED_LO = 1;
    public static final int PUSH1_COLOR_RED_LO_SBLINK = 2;
    public static final int PUSH1_COLOR_RED_LO_FBLINK = 3;
    public static final int PUSH1_COLOR_RED_HI = 4;
    public static final int PUSH1_COLOR_RED_HI_SBLINK = 5;
    public static final int PUSH1_COLOR_RED_HI_FBLINK = 6;
    public static final int PUSH1_COLOR_ORANGE_LO = 7;
    public static final int PUSH1_COLOR_ORANGE_LO_SBLINK = 8;
    public static final int PUSH1_COLOR_ORANGE_LO_FBLINK = 9;
    public static final int PUSH1_COLOR_ORANGE_HI = 10;
    public static final int PUSH1_COLOR_ORANGE_HI_SBLINK = 11;
    public static final int PUSH1_COLOR_ORANGE_HI_FBLINK = 12;
    public static final int PUSH1_COLOR_YELLOW_LO = 13;
    public static final int PUSH1_COLOR_YELLOW_LO_SBLINK = 14;
    public static final int PUSH1_COLOR_YELLOW_LO_FBLINK = 15;
    public static final int PUSH1_COLOR_YELLOW_MD = 16;
    public static final int PUSH1_COLOR_YELLOW_MD_SBLINK = 17;
    public static final int PUSH1_COLOR_YELLOW_MD_FBLINK = 18;
    public static final int PUSH1_COLOR_GREEN_LO = 19;
    public static final int PUSH1_COLOR_GREEN_LO_SBLINK = 20;
    public static final int PUSH1_COLOR_GREEN_LO_FBLINK = 21;
    public static final int PUSH1_COLOR_GREEN_HI = 22;
    public static final int PUSH1_COLOR_GREEN_HI_SBLINK = 23;
    public static final int PUSH1_COLOR_GREEN_HI_FBLINK = 24;
    public static final int PUSH1_COLOR2_BLACK = 0;
    public static final int PUSH1_COLOR2_GREY_LO = 1;
    public static final int PUSH1_COLOR2_GREY_MD = 103;
    public static final int PUSH1_COLOR2_GREY_LT = 2;
    public static final int PUSH1_COLOR2_WHITE = 3;
    public static final int PUSH1_COLOR2_ROSE = 4;
    public static final int PUSH1_COLOR2_RED_HI = 5;
    public static final int PUSH1_COLOR2_RED = 6;
    public static final int PUSH1_COLOR2_RED_LO = 7;
    public static final int PUSH1_COLOR2_RED_AMBER = 8;
    public static final int PUSH1_COLOR2_AMBER_HI = 9;
    public static final int PUSH1_COLOR2_AMBER = 10;
    public static final int PUSH1_COLOR2_AMBER_LO = 11;
    public static final int PUSH1_COLOR2_AMBER_YELLOW = 12;
    public static final int PUSH1_COLOR2_YELLOW_HI = 13;
    public static final int PUSH1_COLOR2_YELLOW = 14;
    public static final int PUSH1_COLOR2_YELLOW_LO = 15;
    public static final int PUSH1_COLOR2_YELLOW_LIME = 16;
    public static final int PUSH1_COLOR2_LIME_HI = 17;
    public static final int PUSH1_COLOR2_LIME = 18;
    public static final int PUSH1_COLOR2_LIME_LO = 19;
    public static final int PUSH1_COLOR2_LIME_GREEN = 20;
    public static final int PUSH1_COLOR2_GREEN_HI = 21;
    public static final int PUSH1_COLOR2_GREEN = 22;
    public static final int PUSH1_COLOR2_GREEN_LO = 23;
    public static final int PUSH1_COLOR2_GREEN_SPRING = 24;
    public static final int PUSH1_COLOR2_SPRING_HI = 25;
    public static final int PUSH1_COLOR2_SPRING = 26;
    public static final int PUSH1_COLOR2_SPRING_LO = 27;
    public static final int PUSH1_COLOR2_SPRING_TURQUOISE = 28;
    public static final int PUSH1_COLOR2_TURQUOISE_LO = 29;
    public static final int PUSH1_COLOR2_TURQUOISE = 30;
    public static final int PUSH1_COLOR2_TURQUOISE_HI = 31;
    public static final int PUSH1_COLOR2_TURQUOISE_CYAN = 32;
    public static final int PUSH1_COLOR2_CYAN_HI = 33;
    public static final int PUSH1_COLOR2_CYAN = 34;
    public static final int PUSH1_COLOR2_CYAN_LO = 35;
    public static final int PUSH1_COLOR2_CYAN_SKY = 36;
    public static final int PUSH1_COLOR2_SKY_HI = 37;
    public static final int PUSH1_COLOR2_SKY = 38;
    public static final int PUSH1_COLOR2_SKY_LO = 39;
    public static final int PUSH1_COLOR2_SKY_OCEAN = 40;
    public static final int PUSH1_COLOR2_OCEAN_HI = 41;
    public static final int PUSH1_COLOR2_OCEAN = 42;
    public static final int PUSH1_COLOR2_OCEAN_LO = 43;
    public static final int PUSH1_COLOR2_OCEAN_BLUE = 44;
    public static final int PUSH1_COLOR2_BLUE_HI = 45;
    public static final int PUSH1_COLOR2_BLUE = 46;
    public static final int PUSH1_COLOR2_BLUE_LO = 47;
    public static final int PUSH1_COLOR2_BLUE_ORCHID = 48;
    public static final int PUSH1_COLOR2_ORCHID_HI = 49;
    public static final int PUSH1_COLOR2_ORCHID = 50;
    public static final int PUSH1_COLOR2_ORCHID_LO = 51;
    public static final int PUSH1_COLOR2_ORCHID_MAGENTA = 52;
    public static final int PUSH1_COLOR2_MAGENTA_HI = 53;
    public static final int PUSH1_COLOR2_MAGENTA = 54;
    public static final int PUSH1_COLOR2_MAGENTA_LO = 55;
    public static final int PUSH1_COLOR2_MAGENTA_PINK = 56;
    public static final int PUSH1_COLOR2_PINK_HI = 57;
    public static final int PUSH1_COLOR2_PINK = 58;
    public static final int PUSH1_COLOR2_PINK_LO = 59;
    public static final int PUSH1_COLOR2_SILVER = 118;
    public static final int PUSH1_COLOR2_ORANGE = 65;
    public static final int PUSH1_COLOR2_ORANGE_LIGHT = 3;
    public static final int PUSH1_COLOR2_LIGHT_BROWN = 69;
    public static final int PUSH1_COLOR_SCENE_RED = 1;
    public static final int PUSH1_COLOR_SCENE_RED_BLINK = 2;
    public static final int PUSH1_COLOR_SCENE_RED_BLINK_FAST = 3;
    public static final int PUSH1_COLOR_SCENE_RED_HI = 4;
    public static final int PUSH1_COLOR_SCENE_RED_HI_BLINK = 5;
    public static final int PUSH1_COLOR_SCENE_RED_HI_BLINK_FAST = 6;
    public static final int PUSH1_COLOR_SCENE_ORANGE = 7;
    public static final int PUSH1_COLOR_SCENE_ORANGE_BLINK = 8;
    public static final int PUSH1_COLOR_SCENE_ORANGE_BLINK_FAST = 9;
    public static final int PUSH1_COLOR_SCENE_ORANGE_HI = 10;
    public static final int PUSH1_COLOR_SCENE_ORANGE_HI_BLINK = 11;
    public static final int PUSH1_COLOR_SCENE_ORANGE_HI_BLINK_FAST = 12;
    public static final int PUSH1_COLOR_SCENE_YELLOW = 13;
    public static final int PUSH1_COLOR_SCENE_YELLOW_BLINK = 14;
    public static final int PUSH1_COLOR_SCENE_YELLOW_BLINK_FAST = 15;
    public static final int PUSH1_COLOR_SCENE_YELLOW_HI = 16;
    public static final int PUSH1_COLOR_SCENE_YELLOW_HI_BLINK = 17;
    public static final int PUSH1_COLOR_SCENE_YELLOW_HI_BLINK_FAST = 18;
    public static final int PUSH1_COLOR_SCENE_GREEN = 19;
    public static final int PUSH1_COLOR_SCENE_GREEN_BLINK = 20;
    public static final int PUSH1_COLOR_SCENE_GREEN_BLINK_FAST = 21;
    public static final int PUSH1_COLOR_SCENE_GREEN_HI = 22;
    public static final int PUSH1_COLOR_SCENE_GREEN_HI_BLINK = 23;
    public static final int PUSH1_COLOR_SCENE_GREEN_HI_BLINK_FAST = 24;
    public static final String PUSH_BLACK = "PUSH_BLACK";
    public static final String PUSH_RED = "PUSH_RED";
    public static final String PUSH_RED_LO = "PUSH_RED_LO";
    public static final String PUSH_RED_HI = "PUSH_RED_HI";
    public static final String PUSH_ORANGE_LO = "PUSH_ORANGE_LO";
    public static final String PUSH_ORANGE_HI = "PUSH_ORANGE_HI";
    public static final String PUSH_YELLOW_LO = "PUSH_YELLOW_LO";
    public static final String PUSH_YELLOW_MD = "PUSH_YELLOW_MD";
    public static final String PUSH_GREEN_LO = "PUSH_GREEN_LO";
    public static final String PUSH_GREEN_HI = "PUSH_GREEN_HI";
    public static final String PUSH_BLACK_2 = "PUSH_BLACK_2";
    public static final String PUSH_WHITE_2 = "PUSH_WHITE_2";
    public static final String PUSH_GREY_LO_2 = "PUSH_GREY_LO_2";
    public static final String PUSH_GREEN_2 = "PUSH_GREEN_2";
    private static final Set<ButtonID> MONOCHROME_BUTTONS = new HashSet<ButtonID>();
    private final PushVersion pushVersion;

    public PushColorManager(PushVersion pushVersion) {
        this.pushVersion = pushVersion;
        boolean isModern = this.pushVersion != PushVersion.VERSION_1;
        boolean isPush3 = this.pushVersion == PushVersion.VERSION_3;
        this.registerColorIndex(PUSH_BLACK, isModern ? 0 : 0);
        this.registerColorIndex(PUSH_RED, isModern ? 5 : 4);
        this.registerColorIndex(PUSH_RED_LO, isModern ? 7 : 1);
        this.registerColorIndex(PUSH_RED_HI, isModern ? 5 : 4);
        this.registerColorIndex(PUSH_ORANGE_LO, isModern ? 11 : 7);
        this.registerColorIndex(PUSH_ORANGE_HI, isModern ? 9 : 10);
        this.registerColorIndex(PUSH_YELLOW_LO, isModern ? 15 : 13);
        this.registerColorIndex(PUSH_YELLOW_MD, isModern ? 13 : 16);
        this.registerColorIndex(PUSH_GREEN_LO, isModern ? 23 : 19);
        this.registerColorIndex(PUSH_GREEN_HI, isModern ? 21 : 22);
        this.registerColorIndex(PUSH_BLACK_2, isModern ? 0 : 0);
        this.registerColorIndex(PUSH_WHITE_2, isModern ? 3 : 3);
        this.registerColorIndex(PUSH_GREY_LO_2, isModern ? 1 : 1);
        this.registerColorIndex(PUSH_GREEN_2, isModern ? 22 : 22);
        this.registerColorIndex("SCALE_COLOR_OFF", isModern ? 0 : 0);
        this.registerColorIndex("SCALE_COLOR_OCTAVE", isModern ? 41 : 41);
        this.registerColorIndex("SCALE_COLOR_NOTE", isModern ? 3 : 3);
        this.registerColorIndex("SCALE_COLOR_OUT_OF_SCALE", isModern ? 0 : 0);
        this.registerColorIndex("BUTTON_COLOR_OFF", isModern ? 0 : 0);
        this.registerColorIndex("BUTTON_COLOR_ON", isModern ? 1 : 19);
        this.registerColorIndex("BUTTON_COLOR_HI", isModern ? 3 : 16);
        this.registerColorIndex("BUTTON_COLOR2_ON", isModern ? 1 : 23);
        this.registerColorIndex("BUTTON_COLOR2_HI", isModern ? 3 : 13);
        this.registerColorIndex("COLOR_NO_CONTENT", isModern ? 0 : 0);
        this.registerColorIndex("COLOR_NO_CONTENT_4", isModern ? 0 : 0);
        this.registerColorIndex("COLOR_CONTENT", isModern ? 45 : 45);
        this.registerColorIndex("COLOR_CONTENT_CONT", isModern ? 47 : 47);
        this.registerColorIndex("COLOR_STEP_HILITE_NO_CONTENT", isModern ? 23 : 23);
        this.registerColorIndex("COLOR_STEP_HILITE_CONTENT", isModern ? 21 : 21);
        this.registerColorIndex("COLOR_STEP_MUTED", isModern ? 103 : 103);
        this.registerColorIndex("COLOR_STEP_MUTED_CONT", isModern ? 1 : 1);
        this.registerColorIndex("COLOR_STEP_SELECTED", isModern ? 13 : 13);
        this.registerColorIndex("COLOR_PAGE", isModern ? 3 : 3);
        this.registerColorIndex("COLOR_ACTIVE_PAGE", isModern ? 22 : 22);
        this.registerColorIndex("COLOR_SELECTED_PAGE", isModern ? 41 : 41);
        this.registerColorIndex("COLOR_RESOLUTION", isModern ? 10 : 7);
        this.registerColorIndex("COLOR_RESOLUTION_SELECTED", isModern ? 9 : 10);
        this.registerColorIndex("COLOR_RESOLUTION_OFF", isModern ? 0 : 0);
        this.registerColorIndex("COLOR_TRANSPOSE", isModern ? 60 : 13);
        this.registerColorIndex("COLOR_TRANSPOSE_SELECTED", isModern ? 13 : 16);
        this.registerColorIndex("COLOR_PAD_OFF", isModern ? 0 : 0);
        this.registerColorIndex("COLOR_PAD_RECORD", isModern ? 5 : 5);
        this.registerColorIndex("COLOR_PAD_PLAY", isModern ? 21 : 21);
        this.registerColorIndex("COLOR_PAD_SELECTED", isModern ? 45 : 45);
        this.registerColorIndex("COLOR_PAD_MUTED", isModern ? 11 : 11);
        this.registerColorIndex("COLOR_PAD_HAS_CONTENT", isModern ? 13 : 13);
        this.registerColorIndex("COLOR_PAD_NO_CONTENT", isModern ? 15 : 15);
        this.registerColorIndex("PLAY_VIEW_COLOR_PLAY", isModern ? 21 : 21);
        this.registerColorIndex("PLAY_VIEW_COLOR_RECORD", isModern ? 5 : 5);
        this.registerColorIndex("PLAY_VIEW_COLOR_OFF", isModern ? 0 : 0);
        this.registerColorIndex("COLOR_OUTSIDE", isModern ? 0 : 0);
        this.registerColorIndex("COLOR_PART", isModern ? 41 : 41);
        this.registerColorIndex("COLOR_SCENE", isModern ? 22 : 19);
        this.registerColorIndex("COLOR_SELECTED_SCENE", isModern ? 21 : 22);
        this.registerColorIndex("COLOR_SELECTED_OFF", isModern ? 0 : 0);
        this.registerColorIndex("COLOR_SELECTED_PLAY_SCENE", isModern ? 3 : 3);
        this.registerColorIndex("GRID_COLOR_OFF", isModern ? 0 : 0);
        this.registerColorIndex(NOTE_REPEAT_PERIOD_OFF, isModern ? 14 : 13);
        this.registerColorIndex(NOTE_REPEAT_PERIOD_HI, isModern ? 13 : 16);
        this.registerColorIndex(NOTE_REPEAT_LENGTH_OFF, isModern ? 6 : 1);
        this.registerColorIndex(NOTE_REPEAT_LENGTH_HI, isModern ? 5 : 4);
        this.registerColorIndex(DAWColor.COLOR_OFF, isModern ? 0 : 0);
        this.registerColorIndex(DAWColor.DAW_COLOR_GRAY_HALF, isModern ? 70 : 103);
        this.registerColorIndex(DAWColor.DAW_COLOR_DARK_GRAY, isModern ? 71 : 1);
        this.registerColorIndex(DAWColor.DAW_COLOR_GRAY, isModern ? 72 : 103);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_GRAY, isModern ? 73 : 2);
        this.registerColorIndex(DAWColor.DAW_COLOR_SILVER, isModern ? 74 : 40);
        this.registerColorIndex(DAWColor.DAW_COLOR_DARK_BROWN, isModern ? 75 : 11);
        this.registerColorIndex(DAWColor.DAW_COLOR_BROWN, isModern ? 76 : 12);
        this.registerColorIndex(DAWColor.DAW_COLOR_DARK_BLUE, isModern ? 77 : 42);
        this.registerColorIndex(DAWColor.DAW_COLOR_PURPLE_BLUE, isModern ? 78 : 44);
        this.registerColorIndex(DAWColor.DAW_COLOR_PURPLE, isModern ? 79 : 81);
        this.registerColorIndex(DAWColor.DAW_COLOR_PINK, isModern ? 80 : 57);
        this.registerColorIndex(DAWColor.DAW_COLOR_RED, isModern ? 81 : 6);
        this.registerColorIndex(DAWColor.DAW_COLOR_ORANGE, isModern ? 82 : 60);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_ORANGE, isModern ? 83 : 62);
        this.registerColorIndex(DAWColor.DAW_COLOR_MOSS_GREEN, isModern ? 84 : 19);
        this.registerColorIndex(DAWColor.DAW_COLOR_GREEN, isModern ? 85 : 26);
        this.registerColorIndex(DAWColor.DAW_COLOR_COLD_GREEN, isModern ? 86 : 30);
        this.registerColorIndex(DAWColor.DAW_COLOR_BLUE, isModern ? 87 : 37);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_PURPLE, isModern ? 88 : 48);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_PINK, isModern ? 89 : 56);
        this.registerColorIndex(DAWColor.DAW_COLOR_ROSE, isModern ? 90 : 4);
        this.registerColorIndex(DAWColor.DAW_COLOR_REDDISH_BROWN, isModern ? 91 : 10);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_BROWN, isModern ? 92 : 61);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_GREEN, isModern ? 93 : 18);
        this.registerColorIndex(DAWColor.DAW_COLOR_BLUISH_GREEN, isModern ? 94 : 25);
        this.registerColorIndex(DAWColor.DAW_COLOR_GREEN_BLUE, isModern ? 95 : 32);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_BLUE, isModern ? 96 : 41);
        this.registerColorIndex("BUTTON_STATE_OFF", 0);
        this.registerColorIndex("BUTTON_STATE_ON", isModern ? 30 : 1);
        this.registerColorIndex("BUTTON_STATE_HI", isModern ? 127 : 4);
        this.registerColorIndex(PUSH_BUTTON_STATE_REC_ON, isModern ? 1 : 1);
        this.registerColorIndex(PUSH_BUTTON_STATE_REC_HI, isModern ? 5 : 4);
        this.registerColorIndex(PUSH_BUTTON_STATE_OVR_ON, isModern ? 1 : 1);
        this.registerColorIndex(PUSH_BUTTON_STATE_OVR_HI, isModern ? 10 : 2);
        this.registerColorIndex(PUSH_BUTTON_STATE_PLAY_ON, isModern ? 1 : 1);
        this.registerColorIndex(PUSH_BUTTON_STATE_PLAY_HI, isModern ? 21 : 4);
        this.registerColorIndex(PUSH_BUTTON_STATE_MUTE_ON, isModern ? 1 : 1);
        this.registerColorIndex(PUSH_BUTTON_STATE_MUTE_HI, isModern ? 11 : 4);
        this.registerColorIndex(PUSH_BUTTON_STATE_SOLO_ON, isModern ? 1 : 1);
        this.registerColorIndex(PUSH_BUTTON_STATE_SOLO_HI, isModern ? 14 : 4);
        this.registerColorIndex(PUSH_BUTTON_STATE_STOP_ON, isModern ? 7 : 1);
        this.registerColorIndex(PUSH_BUTTON_STATE_STOP_HI, isModern ? 5 : 4);
        this.registerColorIndex(PUSH_BUTTON_STATE_MASTER_ON, isPush3 ? 1 : 30);
        this.registerColorIndex(PUSH_BUTTON_STATE_MASTER_HI, isPush3 ? 3 : 127);
        this.registerColorIndex(PUSH_BUTTON_STATE_LOCK_ON, 1);
        this.registerColorIndex(PUSH_BUTTON_STATE_LOCK_HI, 7);
        this.registerColorIndex(PUSH_BUTTON_STATE_INSERT_SCENE_ON, 1);
        this.registerColorIndex(PUSH_BUTTON_STATE_INSERT_SCENE_HI, 3);
        for (int i = 0; i < 128; ++i) {
            this.registerColor(i, PushColorManager.getPaletteColor(i));
        }
    }

    public static int[] getPaletteColorRGB(int index) {
        if (index >= 70 && index <= 96) {
            return DAWColor.getColorEntry(index - 69).toIntRGB255();
        }
        return DEFAULT_PALETTE[index];
    }

    public static ColorEx getPaletteColor(int index) {
        if (index >= 70 && index <= 96) {
            return DAWColor.getColorEntry(index - 69);
        }
        return ColorEx.fromRGB(DEFAULT_PALETTE[index][0], DEFAULT_PALETTE[index][1], DEFAULT_PALETTE[index][2]);
    }

    @Override
    public ColorEx getColor(int colorIndex, ButtonID buttonID) {
        ColorEx color;
        if (colorIndex < 0) {
            return ColorEx.BLACK;
        }
        if (MONOCHROME_BUTTONS.contains((Object)buttonID)) {
            if (colorIndex == this.getColorIndex("BUTTON_STATE_OFF")) {
                return ColorEx.BLACK;
            }
            if (colorIndex == this.getColorIndex("BUTTON_STATE_ON")) {
                return ColorEx.DARK_GRAY;
            }
            return ColorEx.LIGHT_GRAY;
        }
        if (this.pushVersion == PushVersion.VERSION_1) {
            switch (buttonID) {
                case PLAY: {
                    return (ColorEx)this.colorByIndex.get(colorIndex == 1 ? 1 : 21);
                }
                case AUTOMATION: 
                case RECORD: {
                    if (colorIndex == 1) {
                        return ColorEx.DARK_GRAY;
                    }
                    if (colorIndex == 4) {
                        return ColorEx.RED;
                    }
                    return ColorEx.DARK_RED;
                }
                case MUTE: {
                    return colorIndex == 1 ? ColorEx.DARK_ORANGE : ColorEx.ORANGE;
                }
                case SOLO: {
                    return colorIndex == 1 ? ColorEx.DARK_BLUE : ColorEx.BLUE;
                }
                case STOP_CLIP: {
                    return colorIndex == 1 ? ColorEx.DARK_RED : ColorEx.RED;
                }
            }
        }
        if ((color = (ColorEx)this.colorByIndex.get(colorIndex)) == null) {
            throw new ColorIndexException("Color for index " + colorIndex + " is not registered!");
        }
        return color;
    }

    static {
        MONOCHROME_BUTTONS.add(ButtonID.ACCENT);
        MONOCHROME_BUTTONS.add(ButtonID.ADD_EFFECT);
        MONOCHROME_BUTTONS.add(ButtonID.ADD_TRACK);
        MONOCHROME_BUTTONS.add(ButtonID.ARROW_DOWN);
        MONOCHROME_BUTTONS.add(ButtonID.ARROW_LEFT);
        MONOCHROME_BUTTONS.add(ButtonID.ARROW_RIGHT);
        MONOCHROME_BUTTONS.add(ButtonID.ARROW_UP);
        MONOCHROME_BUTTONS.add(ButtonID.BROWSE);
        MONOCHROME_BUTTONS.add(ButtonID.CLIP);
        MONOCHROME_BUTTONS.add(ButtonID.DELETE);
        MONOCHROME_BUTTONS.add(ButtonID.DEVICE);
        MONOCHROME_BUTTONS.add(ButtonID.DOUBLE);
        MONOCHROME_BUTTONS.add(ButtonID.DUPLICATE);
        MONOCHROME_BUTTONS.add(ButtonID.FIXED_LENGTH);
        MONOCHROME_BUTTONS.add(ButtonID.HELP);
        MONOCHROME_BUTTONS.add(ButtonID.INSERT_SCENE);
        MONOCHROME_BUTTONS.add(ButtonID.LAYOUT);
        MONOCHROME_BUTTONS.add(ButtonID.LOAD);
        MONOCHROME_BUTTONS.add(ButtonID.LOCK_MODE);
        MONOCHROME_BUTTONS.add(ButtonID.MASTERTRACK);
        MONOCHROME_BUTTONS.add(ButtonID.METRONOME);
        MONOCHROME_BUTTONS.add(ButtonID.NEW);
        MONOCHROME_BUTTONS.add(ButtonID.NOTE);
        MONOCHROME_BUTTONS.add(ButtonID.OCTAVE_DOWN);
        MONOCHROME_BUTTONS.add(ButtonID.OCTAVE_UP);
        MONOCHROME_BUTTONS.add(ButtonID.PAGE_LEFT);
        MONOCHROME_BUTTONS.add(ButtonID.PAGE_RIGHT);
        MONOCHROME_BUTTONS.add(ButtonID.PAN_SEND);
        MONOCHROME_BUTTONS.add(ButtonID.QUANTIZE);
        MONOCHROME_BUTTONS.add(ButtonID.REPEAT);
        MONOCHROME_BUTTONS.add(ButtonID.SAVE);
        MONOCHROME_BUTTONS.add(ButtonID.SCALES);
        MONOCHROME_BUTTONS.add(ButtonID.SELECT);
        MONOCHROME_BUTTONS.add(ButtonID.SESSION);
        MONOCHROME_BUTTONS.add(ButtonID.SETUP);
        MONOCHROME_BUTTONS.add(ButtonID.SHIFT);
        MONOCHROME_BUTTONS.add(ButtonID.TAP_TEMPO);
        MONOCHROME_BUTTONS.add(ButtonID.TRACK);
        MONOCHROME_BUTTONS.add(ButtonID.UNDO);
        MONOCHROME_BUTTONS.add(ButtonID.USER);
        MONOCHROME_BUTTONS.add(ButtonID.VOLUME);
    }
}

