/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class SelectSessionViewCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    private boolean isTemporary;

    public SelectSessionViewCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    public void setTemporary() {
        this.isTemporary = true;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        if (event == ButtonEvent.DOWN) {
            this.isTemporary = false;
            ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
            if (Views.isSessionView((Views)((Object)viewManager.getActiveID()))) {
                if (modeManager.isActive(new Modes[]{Modes.SESSION_VIEW_SELECT})) {
                    modeManager.restore();
                } else {
                    modeManager.setTemporary(Modes.SESSION_VIEW_SELECT);
                }
                return;
            }
            PushConfiguration configuration = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
            viewManager.setActive(configuration.isScenesClipViewSelected() ? Views.SCENE_PLAY : Views.SESSION);
            return;
        }
        if (event == ButtonEvent.UP && this.isTemporary) {
            viewManager.restore();
        }
    }
}

