/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.device.DeviceBrowserMode;
import de.mossgrabers.framework.command.TempoCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.GrooveParameterID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class RasteredKnobCommand
extends TempoCommand<PushControlSurface, PushConfiguration> {
    private boolean isTempoMode = true;

    public RasteredKnobCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(int value) {
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.BROWSER})) {
            DeviceBrowserMode mode = (DeviceBrowserMode)modeManager.get(Modes.BROWSER);
            mode.changeSelectedColumnValue(value);
            return;
        }
        if (((PushControlSurface)this.surface).isSelectPressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            this.transport.changeLoopStart(this.model.getValueChanger().isIncrease(value), ((PushControlSurface)this.surface).isKnobSensitivitySlow());
            return;
        }
        if (this.isTempoMode) {
            super.execute(value);
            this.mvHelper.notifyTempo();
        } else {
            this.model.getGroove().getParameter(GrooveParameterID.SHUFFLE_AMOUNT).changeValue(value);
            this.mvHelper.notifyShuffle();
        }
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        boolean activate;
        boolean bl = activate = event != ButtonEvent.UP;
        if (((PushControlSurface)this.surface).isSelectPressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            if (activate) {
                this.mvHelper.delayDisplay(() -> "Loop Start: " + this.transport.getLoopStartBeatText());
            }
            return;
        }
        if (((PushControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.BROWSER})) {
            return;
        }
        if (this.isTempoMode) {
            this.transport.setTempoIndication(activate);
            if (activate) {
                this.mvHelper.notifyTempo();
            }
        } else if (activate) {
            this.mvHelper.notifyShuffle();
        }
    }

    public void notifyMode() {
        if (((PushControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.BROWSER})) {
            return;
        }
        if (this.isTempoMode) {
            this.mvHelper.notifyTempo();
        } else {
            this.mvHelper.notifyShuffle();
        }
    }

    public void toggleMode() {
        this.isTempoMode = !this.isTempoMode;
    }
}

