/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.continuous;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.daw.IModel;

public class PushMasterVolumeCommand
extends AbstractContinuousCommand<PushControlSurface, PushConfiguration> {
    private boolean isMasterVolumeMode = true;

    public PushMasterVolumeCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(int value) {
        if (((PushControlSurface)this.surface).isSelectPressed()) {
            this.model.getApplication().getZoomParameter().changeValue(value);
            return;
        }
        if (this.isMasterVolumeMode) {
            this.model.getMasterTrack().changeVolume(value);
        } else {
            this.model.getProject().changeCueVolume(value);
        }
    }

    public void toggleMasterVolumeAndCue() {
        this.isMasterVolumeMode = !this.isMasterVolumeMode;
    }

    public void notifyMode() {
        ((PushControlSurface)this.surface).getDisplay().notify(this.isMasterVolumeMode ? "Master Volume" : "Cue Volume");
    }
}

