/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.dialog;

import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.reaper.AppCallback;
import de.mossgrabers.reaper.framework.daw.BrowserContentType;
import de.mossgrabers.reaper.framework.daw.BrowserImpl;
import de.mossgrabers.reaper.framework.device.DeviceMetadataImpl;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.ui.dialog.BasicDialog;
import de.mossgrabers.reaper.ui.widget.BoxPanel;
import de.mossgrabers.reaper.ui.widget.Functions;
import de.mossgrabers.reaper.ui.widget.JListX;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;

public class BrowserDialog
extends BasicDialog {
    private static final long serialVersionUID = -4991119574575580454L;
    private static final int MAX_FILTER_COLUMNS = 7;
    private final transient AppCallback callback;
    private final List<JListX<String>> filterListBox = new ArrayList<JListX<String>>();
    private final List<BoxPanel> filterPanels = new ArrayList<BoxPanel>();
    private final List<JLabel> filterColumnLabels = new ArrayList<JLabel>();
    private final JLabel infoTextLabel = new JLabel();
    private JListX<String> resultListBox;
    private transient BrowserImpl browser;
    private final transient Object browserLock = new Object();
    private JMenu displayMenu = null;

    public BrowserDialog(JFrame owner, AppCallback callback) {
        super(owner, "Browser", false, false);
        this.callback = callback;
        URL resource = this.getClass().getResource("/images/AppIcon.gif");
        Image image = Toolkit.getDefaultToolkit().getImage(resource);
        if (image != null) {
            this.setIconImage(image);
        }
        this.getRootPane().registerKeyboardAction(e -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 2);
        this.setMinimumSize(new Dimension(800, 600));
        this.basicInit();
        this.createMenu();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    protected Container init() {
        JPanel contentPane = new JPanel(new BorderLayout());
        BoxPanel columnWidgets = new BoxPanel(0, true);
        int i = 0;
        while (i < 7) {
            BoxPanel columnPanel = new BoxPanel(1, false);
            this.filterPanels.add(columnPanel);
            JListX listBox = columnPanel.createListBox("-", null, 0, Collections.emptyList());
            listBox.setSelectionMode(0);
            listBox.setPrototypeCellValue("01234567890123456789012");
            this.filterListBox.add(listBox);
            columnWidgets.addComponent(columnPanel, 12);
            this.filterColumnLabels.add((JLabel)columnPanel.getComponent(0));
            int index = i++;
            listBox.addListSelectionListener(e -> this.filterChanges(index, e));
        }
        BoxPanel columnPanel = new BoxPanel(1, false);
        this.resultListBox = columnPanel.createListBox("Results:", null, 0, Collections.emptyList());
        this.resultListBox.setSelectionMode(0);
        this.resultListBox.setPrototypeCellValue("012345678901234567890123456");
        this.resultListBox.addListSelectionListener(this::filterResultChanges);
        this.resultListBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    BrowserDialog.this.ok();
                }
            }
        });
        columnWidgets.addComponent(columnPanel, 0);
        BoxPanel infoPane = new BoxPanel(0, true);
        infoPane.add(this.infoTextLabel);
        Font f = this.infoTextLabel.getFont();
        this.infoTextLabel.setFont(f.deriveFont(f.getStyle() | 1));
        contentPane.add((Component)infoPane, "North");
        contentPane.add((Component)columnWidgets, "Center");
        BoxPanel buttons = new BoxPanel(0, true);
        buttons.createSpace(-1);
        JButton cancelButton = buttons.createButton(Functions.getIcon("Remove"), "Cancel", null, 12);
        JButton okButton = buttons.createButton(Functions.getIcon("Confirm"), "OK", null, 0);
        this.setButtons(okButton, cancelButton);
        Functions.asWidthAs(this.cancel, this.ok);
        contentPane.add((Component)buttons, "South");
        return contentPane;
    }

    private void createMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.displayMenu = new JMenu("View");
        menuBar.add(this.displayMenu);
        this.setJMenuBar(menuBar);
        int i = 0;
        while (i < 7) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("FILTER_COLUMN " + i);
            int col = i++;
            menuItem.addActionListener(e -> this.toggleFilterColumnVisibility(col));
            this.displayMenu.add(menuItem);
        }
        this.displayMenu.addSeparator();
        JMenuItem allMenuItem = new JMenuItem("All");
        allMenuItem.addActionListener(e -> this.toggleFilterColumnVisibilityAll(true));
        this.displayMenu.add(allMenuItem);
        JMenuItem noneMenuItem = new JMenuItem("None");
        noneMenuItem.addActionListener(e -> this.toggleFilterColumnVisibilityAll(false));
        this.displayMenu.add(noneMenuItem);
    }

    private void updateMenu() {
        boolean[] browserColumnsVisibility = this.callback.getBrowserColumnsVisibility(this.browser.getContentType());
        int filterColumnCount = this.browser.getFilterColumnCount();
        for (int col = 0; col < 7; ++col) {
            JMenuItem menuItem = this.displayMenu.getItem(col);
            if (col < filterColumnCount) {
                String name = this.browser.getFilterColumn(col).getName();
                menuItem.setText(name.isBlank() ? "No filter" : name);
                this.setFilterColumnVisible(col, browserColumnsVisibility[col]);
                menuItem.setSelected(browserColumnsVisibility[col]);
                this.setFilterColumnVisible(col, browserColumnsVisibility[col]);
            }
            menuItem.setVisible(col < filterColumnCount);
        }
    }

    private void toggleFilterColumnVisibilityAll(boolean all) {
        for (int col = 0; col < this.browser.getFilterColumnCount(); ++col) {
            this.setFilterColumnVisible(col, all);
            this.updateColumnSettings(col, all);
            ((JCheckBoxMenuItem)this.displayMenu.getMenuComponent(col)).setSelected(all);
        }
    }

    private void toggleFilterColumnVisibility(int column) {
        if (column >= this.filterPanels.size()) {
            return;
        }
        BoxPanel filterCol = this.filterPanels.get(column);
        boolean show = !filterCol.isVisible();
        this.setFilterColumnVisible(column, show);
        this.updateColumnSettings(column, show);
    }

    private void setFilterColumnVisible(int column, boolean show) {
        if (column >= this.filterPanels.size()) {
            return;
        }
        BoxPanel filterCol = this.filterPanels.get(column);
        filterCol.setVisible(show);
        filterCol.getParent().getComponent(column * 2 + 1).setVisible(show);
    }

    protected void updateColumnSettings(int column, boolean show) {
        BrowserContentType contentType = this.browser.getContentType();
        boolean[] browserColumnsVisibility = this.callback.getBrowserColumnsVisibility(contentType);
        browserColumnsVisibility[column] = show;
        this.callback.setBrowserColumnsVisibility(contentType, browserColumnsVisibility);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(BrowserImpl browser) {
        Object object = this.browserLock;
        synchronized (object) {
            if (this.browser != null) {
                this.close(false, false);
            }
            this.browser = browser;
            this.infoTextLabel.setText(this.browser.getInfoText());
        }
    }

    @Override
    public void ok() {
        this.close(true, true);
    }

    @Override
    public void cancel() {
        this.close(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean commit, boolean notifyBrowser) {
        Object object = this.browserLock;
        synchronized (object) {
            this.setVisible(false);
            BrowserImpl b = this.browser;
            this.browser = null;
            if (b != null && notifyBrowser) {
                b.stopBrowsing(commit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResults(int selectedIndex) {
        Object object = this.browserLock;
        synchronized (object) {
            DefaultListModel<String> model;
            if (this.browser == null) {
                return;
            }
            this.updateFilterSelections();
            if (this.browser.isPresetContentType()) {
                model = this.browser.getPresets();
            } else {
                model = new DefaultListModel();
                for (DeviceMetadataImpl device : this.browser.getFilteredDevices()) {
                    model.addElement(device.fullName());
                }
            }
            this.resultListBox.setModel(model);
            this.updateResultSelection(selectedIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFilters() {
        Object object = this.browserLock;
        synchronized (object) {
            if (this.browser == null) {
                return;
            }
            this.setTitle("Browser - " + this.browser.getSelectedContentType());
            int filterColumnCount = this.browser.getFilterColumnCount();
            for (int i = 0; i < 7; ++i) {
                String name;
                JListX<String> list = this.filterListBox.get(i);
                ListModel model = list.getModel();
                ((DefaultListModel)model).clear();
                if (i >= filterColumnCount) continue;
                IBrowserColumn filterColumn = this.browser.getFilterColumn(i);
                if (filterColumn instanceof BaseColumn) {
                    BaseColumn baseFilter = (BaseColumn)filterColumn;
                    ((DefaultListModel)model).addElement("All");
                    for (String item : baseFilter.getAllItems()) {
                        ((DefaultListModel)model).addElement(item);
                    }
                }
                this.filterColumnLabels.get(i).setText((String)((name = filterColumn.getName()).isBlank() ? "No filter:" : name + ":"));
            }
            this.updateMenu();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFilterSelections() {
        Object object = this.browserLock;
        synchronized (object) {
            if (this.browser == null) {
                return;
            }
            int filterColumnCount = this.browser.getFilterColumnCount();
            for (int i = 0; i < 7; ++i) {
                if (i >= filterColumnCount) continue;
                JListX<String> list = this.filterListBox.get(i);
                list.setSelectedIndex(this.browser.getFilterColumn(i).getCursorIndex());
            }
        }
    }

    public void updateResultSelection(int selectedIndex) {
        if (selectedIndex >= 0) {
            this.resultListBox.setSelectedIndex(selectedIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterChanges(int filterIndex, ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        Object object = this.browserLock;
        synchronized (object) {
            if (this.browser == null) {
                return;
            }
            int selectedIndex = this.filterListBox.get(filterIndex).getSelectedIndex();
            if (selectedIndex >= 0) {
                this.browser.setSelectedFilterItemIndex(filterIndex, selectedIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterResultChanges(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        Object object = this.browserLock;
        synchronized (object) {
            if (this.browser == null) {
                return;
            }
            int selectedIndex = this.resultListBox.getSelectedIndex();
            if (selectedIndex >= 0) {
                this.browser.setSelectedResult(selectedIndex);
            }
        }
    }
}

