/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.midi;

import de.mossgrabers.reaper.communication.BackendExchange;
import java.util.Collections;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

public class ReaperMidiDevice
implements MidiDevice,
Receiver {
    private final int index;
    private final String name;
    private final Info info;
    private final boolean isInput;
    private final BackendExchange backend;
    private final Object lifecycleLock = new Object();
    private final Transmitter transmitter;
    private boolean isOpen = false;

    public ReaperMidiDevice(int index, String name, boolean isInput, BackendExchange backend) {
        this.index = index;
        this.name = name;
        this.isInput = isInput;
        this.backend = backend;
        this.info = new Info(name);
        this.transmitter = this.isInput ? new ReaperTransmitter() : null;
    }

    public int getDeviceID() {
        return this.index;
    }

    public void handleMidiMessageFromBackend(MidiMessage message) {
        Receiver receiver = this.transmitter.getReceiver();
        if (receiver != null) {
            receiver.send(message, -1L);
        }
    }

    @Override
    public Info getDeviceInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws MidiUnavailableException {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.isOpen) {
                return;
            }
            if (this.isInput) {
                if (!this.backend.openMidiInput(this.index)) {
                    throw new MidiUnavailableException("MIDI input port #" + this.index + " " + this.name + " is not enabled in Reaper.");
                }
            } else if (!this.backend.openMidiOutput(this.index)) {
                throw new MidiUnavailableException("MIDI output port #" + this.index + " " + this.name + " is not enabled in Reaper.");
            }
            this.isOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (!this.isOpen) {
                return;
            }
            this.isOpen = false;
            if (this.isInput) {
                this.backend.closeMidiInput(this.index);
            } else {
                this.backend.closeMidiOutput(this.index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            return this.isOpen;
        }
    }

    @Override
    public long getMicrosecondPosition() {
        return -1L;
    }

    @Override
    public int getMaxReceivers() {
        return this.isInput ? 1 : 0;
    }

    @Override
    public int getMaxTransmitters() {
        return this.isInput ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (!this.isOpen) {
                throw new MidiUnavailableException("This MIDI output (#" + this.index + " " + this.name + ") has not beend opened.");
            }
        }
        if (this.isInput) {
            throw new MidiUnavailableException("This MIDI device is not an output port #" + this.index + " " + this.name);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Receiver> getReceivers() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            return this.isInput || !this.isOpen ? Collections.emptyList() : Collections.singletonList(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (!this.isOpen) {
                throw new MidiUnavailableException("This MIDI input (#" + this.index + " " + this.name + ") has not beend opened.");
            }
        }
        if (!this.isInput) {
            throw new MidiUnavailableException("This MIDI device is not an input port #" + this.index + " " + this.name);
        }
        return this.transmitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Transmitter> getTransmitters() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            return this.isInput && this.isOpen ? Collections.singletonList(this.transmitter) : Collections.emptyList();
        }
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        this.backend.sendMidiData(this.index, message.getMessage());
    }

    public static class Info
    extends MidiDevice.Info {
        protected Info(String name) {
            super(name, "", "", "");
        }
    }

    private class ReaperTransmitter
    implements Transmitter {
        Receiver receiver = null;

        private ReaperTransmitter() {
        }

        @Override
        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }

        @Override
        public Receiver getReceiver() {
            return this.receiver;
        }

        @Override
        public void close() {
            ReaperMidiDevice.this.close();
        }
    }
}

