/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.IParameterList;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.framework.daw.data.bank.ParameterBankImpl;
import java.util.ArrayList;
import java.util.List;

public class ParameterListImpl
implements IParameterList {
    private final ParameterBankImpl parameterBank;
    private final List<IParameter> parameters = new ArrayList<IParameter>();
    private final IDevice device;
    private String deviceName = null;
    private int devicePosition = -1;

    public ParameterListImpl(int numMonitoredPages, ParameterBankImpl parameterBank, IDevice device) {
        this.parameterBank = parameterBank;
        this.device = device;
    }

    @Override
    public int getMaxNumberOfParameters() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IParameter> getParameters() {
        List<IParameter> list = this.parameters;
        synchronized (list) {
            if (this.deviceName == null || !this.deviceName.equals(this.device.getName()) || this.devicePosition != this.device.getPosition()) {
                this.deviceName = this.device.getName();
                this.devicePosition = this.device.getPosition();
                this.refreshParameterCache();
            }
            return this.parameters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshParameterCache() {
        List<IParameter> list = this.parameters;
        synchronized (list) {
            this.parameters.clear();
            if (this.parameterBank != null) {
                for (int i = 0; i < this.parameterBank.getUnpagedItemCount(); ++i) {
                    this.parameters.add((IParameter)this.parameterBank.getUnpagedItem(i));
                }
            }
        }
    }
}

