/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode;

import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.mode.INoteEditor;
import java.util.ArrayList;
import java.util.List;

public class NoteEditor
implements INoteEditor {
    private INoteClip clip = null;
    private final List<NotePosition> notes = new ArrayList<NotePosition>();

    @Override
    public INoteClip getClip() {
        return this.clip;
    }

    @Override
    public void clearNotes() {
        this.notes.clear();
    }

    @Override
    public void setNote(INoteClip clip, NotePosition notePosition) {
        this.notes.clear();
        this.addNote(clip, notePosition);
    }

    @Override
    public void addNote(INoteClip clip, NotePosition notePosition) {
        this.removeNote(clip, notePosition);
        this.notes.add(new NotePosition(notePosition.getChannel(), notePosition.getStep(), notePosition.getNote()));
    }

    @Override
    public void removeNote(INoteClip clip, NotePosition notePosition) {
        if (this.clip != clip) {
            this.notes.clear();
            this.clip = clip;
        }
        for (NotePosition gridStep : this.notes) {
            if (!gridStep.equals(notePosition)) continue;
            this.notes.remove(gridStep);
            return;
        }
    }

    @Override
    public boolean isNoteEdited(INoteClip clip, NotePosition notePosition) {
        if (this.clip != clip) {
            return false;
        }
        for (NotePosition gridStep : this.notes) {
            if (!gridStep.equals(notePosition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<NotePosition> getNotes() {
        return new ArrayList<NotePosition>(this.notes);
    }

    @Override
    public List<NotePosition> getNotePosition(int parameterIndex) {
        return this.notes;
    }
}

