/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.daw.resource.ResourceHandler;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsDimensions;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.IImage;
import de.mossgrabers.framework.graphics.canvas.component.ChannelSelectComponent;

public class ChannelComponent
extends ChannelSelectComponent {
    public static final int EDIT_TYPE_VOLUME = 0;
    public static final int EDIT_TYPE_PAN = 1;
    public static final int EDIT_TYPE_CROSSFADER = 2;
    public static final int EDIT_TYPE_ALL = 3;
    private final double editType;
    private final double volumeValue;
    private final double modulatedVolumeValue;
    private final String volumeText;
    private final double panValue;
    private final double modulatedPanValue;
    private final String panText;
    private final double vuValueLeft;
    private final double vuValueRight;
    private final boolean isMute;
    private final boolean isSolo;
    private final boolean isArm;
    private final double crossfadeMode;
    private final boolean isActive;
    private final ChannelType type;

    public ChannelComponent(double editType, String menuName, boolean isMenuSelected, String name, ColorEx color, boolean isSelected, ChannelType type, double volumeValue, double modulatedVolumeValue, String volumeText, double panValue, double modulatedPanValue, String panText, double vuValueLeft, double vuValueRight, boolean isMute, boolean isSolo, boolean isArm, boolean isActive, double crossfadeMode, boolean isPinned) {
        super(type, menuName, isMenuSelected, name, color, isSelected, isActive, isPinned);
        this.type = type;
        this.isActive = isActive;
        this.editType = editType;
        this.volumeValue = volumeValue;
        this.modulatedVolumeValue = modulatedVolumeValue;
        this.volumeText = volumeText;
        this.panValue = panValue;
        this.modulatedPanValue = modulatedPanValue;
        this.panText = panText;
        this.vuValueLeft = vuValueLeft;
        this.vuValueRight = vuValueRight;
        this.isMute = isMute;
        this.isSolo = isSolo;
        this.isArm = isArm;
        this.crossfadeMode = crossfadeMode;
    }

    @Override
    public void draw(IGraphicsInfo info) {
        boolean isVolumeTouched;
        boolean isVolumeModulated;
        boolean isPanModulated;
        super.draw(info);
        IGraphicsContext gc = info.getContext();
        IGraphicsDimensions dimensions = info.getDimensions();
        IGraphicsConfiguration configuration = info.getConfiguration();
        double left = info.getBounds().left();
        double width = info.getBounds().width();
        double height = info.getBounds().height();
        double halfWidth = width / 2.0;
        double separatorSize = dimensions.getSeparatorSize();
        double menuHeight = dimensions.getMenuHeight();
        double unit = dimensions.getUnit();
        double halfUnit = dimensions.getHalfUnit();
        double controlsTop = dimensions.getControlsTop();
        double inset = dimensions.getInset();
        double trackRowHeight = 1.2 * unit + 1.0;
        double trackRowTop = height - trackRowHeight - separatorSize;
        double controlWidth = halfWidth - halfUnit - halfUnit / 2.0;
        double controlStart = left + halfWidth + halfUnit - halfUnit / 2.0;
        double panWidth = controlWidth - 2.0;
        double panStart = controlStart + 1.0;
        double panTop = controlsTop + 1.0;
        double panHeight = unit - separatorSize;
        double panTextTop = panTop + panHeight;
        double faderOffset = controlWidth / 4.0;
        double faderTop = panTop + panHeight + separatorSize + 1.0;
        double vuX = controlStart + separatorSize;
        double faderLeft = vuX + faderOffset;
        double faderHeight = trackRowTop - faderTop - inset + 1.0;
        double faderInnerHeight = faderHeight - 2.0 * separatorSize;
        double volumeTextWidth = 1.4 * controlWidth;
        double volumeTextLeft = faderLeft - volumeTextWidth - 2.0;
        ColorEx textColor = this.modifyIfOff(configuration.getColorText());
        String name = this.footer.getText();
        if (name == null || name.length() == 0) {
            return;
        }
        ColorEx backgroundColor = this.modifyIfOff(configuration.getColorBackground());
        gc.fillRectangle(left, menuHeight + 1.0, width, trackRowTop - (menuHeight - 1.0), this.footer.isSelected() ? this.modifyIfOff(configuration.getColorBackgroundLighter()) : backgroundColor);
        ColorEx borderColor = this.modifyIfOff(configuration.getColorBorder());
        gc.fillRectangle(controlStart, controlsTop, halfWidth - unit + halfUnit / 2.0, unit, borderColor);
        gc.fillRectangle(controlStart, faderTop, controlWidth, faderHeight, borderColor);
        ColorEx backgroundDarker = this.modifyIfOff(configuration.getColorBackgroundDarker());
        ColorEx editColor = this.modifyIfOff(configuration.getColorEdit());
        double leftColumn = left + inset - 1.0;
        if (this.type != ChannelType.MASTER && this.type != ChannelType.CUE && this.type != ChannelType.LAYER && this.crossfadeMode != -1.0) {
            ColorEx selColor = this.editType == 2.0 || this.editType == 3.0 ? editColor : ColorEx.darker(editColor);
            double crossOptWidth = controlWidth / 3.0;
            this.drawButton(gc, leftColumn, controlsTop, crossOptWidth, panHeight + 2.0, backgroundColor, this.modifyIfOff(selColor), textColor, this.crossfadeMode == 0.0, "track/crossfade_a.svg", configuration, 0.0);
            this.drawButton(gc, leftColumn + crossOptWidth, controlsTop, crossOptWidth, panHeight + 2.0, backgroundColor, this.modifyIfOff(selColor), textColor, this.crossfadeMode == 1.0, "track/crossfade_ab.svg", configuration, 0.0);
            this.drawButton(gc, leftColumn + 2.0 * crossOptWidth, controlsTop, crossOptWidth, panHeight + 2.0, backgroundColor, this.modifyIfOff(selColor), textColor, this.crossfadeMode == 2.0, "track/crossfade_b.svg", configuration, 0.0);
        }
        gc.fillRectangle(panStart, panTop, panWidth, panHeight, backgroundDarker);
        double panRange = panWidth / 2.0;
        double panMiddle = panStart + panRange;
        gc.drawLine(panMiddle, panTop, panMiddle, panTop + panHeight, borderColor);
        double maxValue = dimensions.getParameterUpperBound();
        double halfMax = maxValue / 2.0;
        boolean isPanTouched = this.panText.length() > 0;
        boolean isRight = this.panValue > halfMax;
        boolean isModulatedRight = this.modulatedPanValue > halfMax;
        double v = isRight ? (this.panValue - halfMax) * panRange / halfMax : panRange - this.panValue * panRange / halfMax;
        boolean bl = isPanModulated = this.modulatedPanValue != -1.0;
        double vMod = isPanModulated ? (isModulatedRight ? (this.modulatedPanValue - halfMax) * panRange / halfMax : panRange - this.modulatedPanValue * panRange / halfMax) : v;
        ColorEx faderColor = this.modifyIfOff(configuration.getColorFader());
        boolean rightMod = isPanModulated ? isModulatedRight : isRight;
        gc.fillRectangle(rightMod ? panMiddle + 1.0 : panMiddle - vMod, controlsTop + 1.0, vMod, panHeight, faderColor);
        if (this.editType == 1.0 || this.editType == 3.0) {
            double w = isPanTouched ? 3.0 : 1.0;
            double start = isRight ? Math.min(panMiddle + panRange - w, panMiddle + v) : Math.max(panMiddle - panRange, panMiddle - v);
            gc.fillRectangle(start, controlsTop + 1.0, w, panHeight, editColor);
        }
        double volumeWidth = controlWidth - 2.0 * separatorSize - faderOffset;
        double volumeHeight = this.volumeValue >= maxValue - 1.0 ? faderInnerHeight : faderInnerHeight * this.volumeValue / maxValue;
        boolean bl2 = isVolumeModulated = this.modulatedVolumeValue != -1.0;
        double modulatedVolumeHeight = isVolumeModulated ? (this.modulatedVolumeValue >= maxValue - 1.0 ? faderInnerHeight : faderInnerHeight * this.modulatedVolumeValue / maxValue) : volumeHeight;
        double volumeTop = faderTop + separatorSize + faderInnerHeight - volumeHeight;
        double modulatedVolumeTop = isVolumeModulated ? faderTop + separatorSize + faderInnerHeight - modulatedVolumeHeight : volumeTop;
        gc.fillRectangle(faderLeft, modulatedVolumeTop, volumeWidth, modulatedVolumeHeight, faderColor);
        boolean bl3 = isVolumeTouched = this.volumeText.length() > 0;
        if (this.editType == 0.0 || this.editType == 3.0) {
            double h = isVolumeTouched ? 3.0 : 1.0;
            gc.fillRectangle(faderLeft, Math.min(volumeTop + volumeHeight - h, volumeTop), volumeWidth, h, editColor);
        }
        double vuHeightLeft = this.vuValueLeft >= maxValue - 1.0 ? faderInnerHeight : faderInnerHeight * this.vuValueLeft / maxValue;
        double vuHeightRight = this.vuValueRight >= maxValue - 1.0 ? faderInnerHeight : faderInnerHeight * this.vuValueRight / maxValue;
        double vuOffsetLeft = faderInnerHeight - vuHeightLeft;
        double vuOffsetRight = faderInnerHeight - vuHeightRight;
        double vuWidth = faderOffset - separatorSize;
        gc.fillRectangle(vuX, faderTop + separatorSize, vuWidth + 1.0, faderInnerHeight, backgroundDarker);
        ColorEx colorVu = this.modifyIfOff(configuration.getColorVu());
        if (this.isMute) {
            colorVu = configuration.getColorMute();
        }
        gc.fillRectangle(vuX, faderTop + separatorSize + vuOffsetLeft, vuWidth / 2.0, vuHeightLeft, colorVu);
        gc.fillRectangle(vuX + vuWidth / 2.0, faderTop + separatorSize + vuOffsetRight, vuWidth / 2.0, vuHeightRight, colorVu);
        if (this.type != ChannelType.CUE) {
            double buttonOffset = 2.0 * unit;
            double buttonTop = faderTop + buttonOffset;
            double buttonHeight = (faderHeight - buttonOffset - 4.0 * separatorSize) / 3.0;
            if (this.type != ChannelType.LAYER) {
                this.drawButton(gc, leftColumn, buttonTop, controlWidth, buttonHeight - 1.0, backgroundColor, this.modifyIfOff(configuration.getColorRecord()), textColor, this.isArm, "channel/record_arm.svg", configuration);
            }
            this.drawButton(gc, leftColumn, buttonTop += buttonHeight + 2.0 * separatorSize, controlWidth, buttonHeight - 1.0, backgroundColor, this.modifyIfOff(configuration.getColorSolo()), textColor, this.isSolo, "channel/solo.svg", configuration);
            this.drawButton(gc, leftColumn, buttonTop += buttonHeight + 2.0 * separatorSize, controlWidth, buttonHeight - 1.0, backgroundColor, this.modifyIfOff(configuration.getColorMute()), textColor, this.isMute, "channel/mute.svg", configuration);
        }
        if (isPanTouched) {
            gc.fillRectangle(controlStart, panTextTop, controlWidth, unit, backgroundDarker);
            gc.strokeRectangle(controlStart, panTextTop, controlWidth, unit, borderColor);
            gc.drawTextInBounds(this.panText, controlStart, panTextTop, controlWidth, unit, Align.CENTER, textColor, unit);
        }
        if (isVolumeTouched) {
            double volumeTextTop = this.volumeValue >= maxValue - 1.0 ? faderTop : Math.min(volumeTop - 1.0, faderTop + faderInnerHeight + separatorSize - unit + 1.0);
            gc.fillRectangle(volumeTextLeft, volumeTextTop, volumeTextWidth, unit, backgroundDarker);
            gc.strokeRectangle(volumeTextLeft, volumeTextTop, volumeTextWidth, unit, borderColor);
            gc.drawTextInBounds(this.volumeText, volumeTextLeft, volumeTextTop, volumeTextWidth, unit, Align.CENTER, textColor, unit);
        }
    }

    private void drawButton(IGraphicsContext gc, double left, double top, double width, double height, ColorEx backgroundColor, ColorEx isOnColor, ColorEx textColor, boolean isOn, String iconName, IGraphicsConfiguration configuration) {
        this.drawButton(gc, left, top, width, height, backgroundColor, isOnColor, textColor, isOn, iconName, configuration, 2.0);
    }

    private void drawButton(IGraphicsContext gc, double left, double top, double width, double height, ColorEx backgroundColor, ColorEx isOnColor, ColorEx textColor, boolean isOn, String iconName, IGraphicsConfiguration configuration, double radius) {
        ColorEx borderColor = this.modifyIfOff(configuration.getColorBorder());
        gc.fillRoundedRectangle(left, top, width, height, radius, borderColor);
        if (isOn) {
            gc.fillRoundedRectangle(left + 1.0, top + 1.0, width - 2.0, height - 2.0, radius, isOnColor);
        } else {
            gc.fillGradientRoundedRectangle(left + 1.0, top + 1.0, width - 2.0, height - 2.0, radius, backgroundColor, ColorEx.brighter(backgroundColor));
        }
        IImage icon = ResourceHandler.getSVGImage(iconName);
        gc.maskImage(icon, left + (width - icon.getWidth()) / 2.0, top + (height - (double)icon.getHeight()) / 2.0, isOn ? borderColor : textColor);
    }

    protected ColorEx modifyIfOff(ColorEx color) {
        return this.isActive ? color : ColorEx.dimToGray(color);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.crossfadeMode);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.editType);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.isActive ? 1231 : 1237);
        result = 31 * result + (this.isArm ? 1231 : 1237);
        result = 31 * result + (this.isMute ? 1231 : 1237);
        result = 31 * result + (this.isSolo ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.modulatedPanValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.modulatedVolumeValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.panText == null ? 0 : this.panText.hashCode());
        temp = Double.doubleToLongBits(this.panValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.volumeText == null ? 0 : this.volumeText.hashCode());
        temp = Double.doubleToLongBits(this.volumeValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.vuValueLeft);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.vuValueRight);
        return 31 * result + (int)(temp ^ temp >>> 32);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelComponent other = (ChannelComponent)obj;
        if (Double.doubleToLongBits(this.crossfadeMode) != Double.doubleToLongBits(other.crossfadeMode) || Double.doubleToLongBits(this.editType) != Double.doubleToLongBits(other.editType) || this.isActive != other.isActive || this.isArm != other.isArm) {
            return false;
        }
        if (this.isMute != other.isMute || this.isSolo != other.isSolo || Double.doubleToLongBits(this.modulatedPanValue) != Double.doubleToLongBits(other.modulatedPanValue) || Double.doubleToLongBits(this.modulatedVolumeValue) != Double.doubleToLongBits(other.modulatedVolumeValue)) {
            return false;
        }
        if (this.panText == null ? other.panText != null : !this.panText.equals(other.panText)) {
            return false;
        }
        if (Double.doubleToLongBits(this.panValue) != Double.doubleToLongBits(other.panValue) || this.type != other.type) {
            return false;
        }
        if (this.volumeText == null ? other.volumeText != null : !this.volumeText.equals(other.volumeText)) {
            return false;
        }
        if (Double.doubleToLongBits(this.volumeValue) != Double.doubleToLongBits(other.volumeValue) || Double.doubleToLongBits(this.vuValueLeft) != Double.doubleToLongBits(other.vuValueLeft)) {
            return false;
        }
        return Double.doubleToLongBits(this.vuValueRight) == Double.doubleToLongBits(other.vuValueRight);
    }
}

