/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.device;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class DeviceLayerRightCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    public DeviceLayerRightCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        ILayerBank bank = cd.getLayerBank();
        Optional sel = bank.getSelectedItem();
        if (!cd.hasLayers() || sel.isEmpty()) {
            cd.selectNext();
        } else {
            bank.selectNextItem();
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.hasLayers()) {
            return;
        }
        ILayerBank bank = cd.getLayerBank();
        Optional layer = bank.getSelectedItem();
        if (layer.isEmpty()) {
            ((ILayer)bank.getItem(0)).select();
        } else {
            ((ILayer)layer.get()).enter();
        }
    }

    public boolean canExecute() {
        if (this.surface.isShiftPressed()) {
            return true;
        }
        ICursorDevice cd = this.model.getCursorDevice();
        ILayerBank bank = cd.getLayerBank();
        Optional layer = bank.getSelectedItem();
        return cd.hasLayers() && layer.isPresent() ? bank.canScrollForwards() : cd.canSelectNext();
    }
}

