/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import java.util.List;

public class SLMkIIIConfiguration
extends AbstractConfiguration {
    public static final Integer ENABLE_FADERS = 100;
    public static final Integer ENABLE_LIGHTGUIDE = 101;
    private boolean enableFaders = true;
    private boolean enableLightguide = true;

    public SLMkIIIConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateScaleBaseSetting(documentSettings);
        this.activateScaleSetting(documentSettings);
        this.activateScaleInScaleSetting(documentSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateBehaviourOnStopSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateKnobSpeedSetting(globalSettings);
        IEnumSetting enableFadersSetting = globalSettings.getEnumSetting("Enable Faders", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        enableFadersSetting.addValueObserver(value -> {
            this.enableFaders = "On".equals(value);
            this.notifyObservers(ENABLE_FADERS);
        });
        this.isSettingActive.add(ENABLE_FADERS);
        IEnumSetting enableLightguideSetting = globalSettings.getEnumSetting("Enable Lightguide", "Workflow", ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        enableLightguideSetting.addValueObserver(value -> {
            this.enableLightguide = "On".equals(value);
            this.notifyObservers(ENABLE_LIGHTGUIDE);
        });
        this.isSettingActive.add(ENABLE_LIGHTGUIDE);
        this.activateSelectClipOnLaunchSetting(globalSettings);
        this.activateDrawRecordStripeSetting(globalSettings);
        this.activateActionForRecArmedPad(globalSettings);
    }

    public boolean areFadersEnabled() {
        return this.enableFaders;
    }

    public boolean isLightEnabled() {
        return this.enableLightguide;
    }
}

