/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.command.trigger;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.view.SessionView;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class SelectSessionViewCommand
extends AbstractTriggerCommand<LaunchpadControlSurface, LaunchpadConfiguration> {
    private TemporaryMode temporaryMode = TemporaryMode.OFF;
    private Views lastView = Views.MIX;

    public SelectSessionViewCommand(IModel model, LaunchpadControlSurface surface) {
        super(model, surface);
    }

    public void setTemporary() {
        this.temporaryMode = TemporaryMode.ACTIVE;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        SessionView sessionView = (SessionView)viewManager.get(Views.SESSION);
        Object configuration = ((LaunchpadControlSurface)this.surface).getConfiguration();
        switch (event) {
            case DOWN: {
                this.temporaryMode = TemporaryMode.OFF;
                if (!((LaunchpadControlSurface)this.surface).isShiftPressed()) break;
                ((LaunchpadControlSurface)this.surface).setTriggerConsumed(ButtonID.SESSION);
                if (viewManager.isActive(new Views[]{Views.MIX, Views.SCENE_PLAY})) {
                    this.lastView = viewManager.isActive(new Views[]{Views.MIX}) ? Views.SCENE_PLAY : Views.MIX;
                }
                viewManager.setActive(this.lastView);
                this.notifyViewName(this.lastView, false, false);
                break;
            }
            case LONG: {
                if (viewManager.isActive(new Views[]{Views.SESSION})) {
                    if (this.temporaryMode != TemporaryMode.POSSIBLE) {
                        ((LaunchpadControlSurface)this.surface).setTriggerConsumed(ButtonID.SESSION);
                        sessionView.setBirdsEyeActive(true);
                        this.notifyViewName(Views.SESSION, true, configuration.isFlipSession());
                    }
                    return;
                }
                this.activatedView(viewManager, (Configuration)configuration);
                break;
            }
            case UP: {
                if (this.temporaryMode == TemporaryMode.ACTIVE) {
                    ((LaunchpadControlSurface)this.surface).getViewManager().restore();
                    return;
                }
                if (this.temporaryMode == TemporaryMode.POSSIBLE) {
                    return;
                }
                if (viewManager.isActive(new Views[]{Views.SESSION})) {
                    if (sessionView.isBirdsEyeActive()) {
                        sessionView.setBirdsEyeActive(false);
                        this.notifyViewName(Views.SESSION, false, configuration.isFlipSession());
                        return;
                    }
                    boolean flipped = !configuration.isFlipSession();
                    configuration.setFlipSession(flipped);
                    this.notifyViewName(Views.SESSION, false, flipped);
                    return;
                }
                this.activatedView(viewManager, (Configuration)configuration);
            }
        }
    }

    private void activatedView(ViewManager viewManager, Configuration configuration) {
        this.temporaryMode = TemporaryMode.POSSIBLE;
        viewManager.setActive(Views.SESSION);
        this.notifyViewName(Views.SESSION, false, configuration.isFlipSession());
    }

    private void notifyViewName(Views activeView, boolean isBirdsEye, boolean isFlipped) {
        ((LaunchpadControlSurface)this.surface).getPadGrid().forceFlush();
        IDisplay display = ((LaunchpadControlSurface)this.surface).getDisplay();
        if (activeView == Views.MIX) {
            display.notify("Mix");
            return;
        }
        if (isBirdsEye) {
            display.notify("Session - Birds Eye");
        } else {
            display.notify(isFlipped ? "Session - Flipped" : "Session");
        }
    }

    private static enum TemporaryMode {
        OFF,
        POSSIBLE,
        ACTIVE;

    }
}

