/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.main;

import de.mossgrabers.controller.novation.launchcontrol.LaunchControlXLConfiguration;
import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLDrumSequencerMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLBaseNoteEditMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import java.util.List;

public class XLDrumPadEditMode
extends XLBaseNoteEditMode {
    private int note;

    public XLDrumPadEditMode(LaunchControlXLControlSurface surface, IModel model, int clipRows, int clipCols, List<ContinuousID> controls) {
        super("Drum Sequencer", surface, model, clipRows, clipCols, controls);
        this.defaultMode = Modes.DRUM_SEQUENCER;
        this.note = this.model.getScales().getDrumOffset();
        CombinedParameterProvider noteEditProvider = new CombinedParameterProvider(this.chanceParameterProvider, this.repeatParameterProvider, this.panParameterProvider);
        CombinedParameterProvider noteEditWithDeviceParamsProvider = new CombinedParameterProvider(this.chanceParameterProvider, this.repeatParameterProvider, this.deviceParameterProvider);
        CombinedParameterProvider shiftedParameterProvider = new CombinedParameterProvider(this.chanceParameterProvider, this.velocitySpreadParameterProvider, this.panParameterProvider);
        this.setParameterProviders(noteEditProvider, noteEditWithDeviceParamsProvider);
        this.setParameterProvider(ButtonID.REC_ARM, shiftedParameterProvider);
    }

    @Override
    protected int getNoteRow(int channel, int step) {
        return this.note;
    }

    @Override
    protected void executeRow0(int index) {
        this.note = this.model.getScales().getDrumOffset() + index;
        ((XLDrumSequencerMode)((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().get(Modes.DRUM_SEQUENCER)).setSelectedPad(index);
        IDrumPad item = this.model.getDrumDevice().getDrumPadBank().getItem(index);
        if (item.doesExist()) {
            this.host.showNotification("Drum Pad: " + item.getName());
        }
    }

    @Override
    protected int getFirstRowColor(int index) {
        boolean isRecording = this.model.hasRecordingState();
        IDrumDevice drumDevice = this.model.getDrumDevice();
        String drumPadColor = this.getDrumPadColor(index, drumDevice.getDrumPadBank(), isRecording);
        return this.colorManager.getColorIndex(drumPadColor);
    }

    @Override
    public void selectPreviousItem() {
        this.scales.decDrumOctave();
        this.adjustDrumDevice();
    }

    @Override
    public void selectNextItem() {
        this.scales.incDrumOctave();
        this.adjustDrumDevice();
    }

    private void adjustDrumDevice() {
        this.model.getDrumDevice().getDrumPadBank().scrollTo(this.scales.getDrumOffset(), false);
        this.host.showNotification(this.scales.getDrumRangeText());
    }

    @Override
    public boolean hasPreviousItem() {
        return this.scales.canScrollDrumOctaveDown();
    }

    @Override
    public boolean hasNextItem() {
        return this.scales.canScrollDrumOctaveUp();
    }

    private String getDrumPadColor(int index, IDrumPadBank drumPadBank, boolean isRecording) {
        int offsetY = this.scales.getDrumOffset();
        if (this.keyManager.isKeyPressed(offsetY + index)) {
            return isRecording ? "COLOR_PAD_RECORD" : "COLOR_PAD_PLAY";
        }
        int selectedPad = ((XLDrumSequencerMode)((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().get(Modes.DRUM_SEQUENCER)).getSelectedPad();
        if (selectedPad == index) {
            return "COLOR_PAD_SELECTED";
        }
        IDrumPad drumPad = drumPadBank.getItem(index);
        if (!drumPad.doesExist() || !drumPad.isActivated()) {
            return ((LaunchControlXLConfiguration)((LaunchControlXLControlSurface)this.surface).getConfiguration()).isTurnOffEmptyDrumPads() ? "COLOR_PAD_OFF" : "COLOR_PAD_NO_CONTENT";
        }
        if (drumPad.isMute() || drumPadBank.hasSoloedPads() && !drumPad.isSolo()) {
            return "COLOR_PAD_MUTED";
        }
        return "COLOR_PAD_HAS_CONTENT";
    }

    @Override
    protected Modes getSequencerMode() {
        return Modes.DRUM_SEQUENCER;
    }
}

