/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.faders;

import de.mossgrabers.controller.novation.launchcontrol.LaunchControlXLConfiguration;
import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.IEqualizerDevice;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import java.util.List;

public class XLEqGainMode
extends AbstractParameterMode<LaunchControlXLControlSurface, LaunchControlXLConfiguration, IParameter> {
    private final IEqualizerDevice eqDevice;
    private final List<IParameter> parameters;

    public XLEqGainMode(LaunchControlXLControlSurface surface, IModel model, List<ContinuousID> controls) {
        super("EQ Gain", surface, model, true, model.getCursorDevice().getParameterBank(), controls);
        this.eqDevice = (IEqualizerDevice)model.getSpecificDevice(DeviceID.EQ);
        this.parameters = this.eqDevice.getGainParameters();
        this.setParameterProvider(new FixedParameterProvider(this.parameters));
    }

    @Override
    public int getKnobValue(int index) {
        if (!this.eqDevice.doesExist()) {
            return -1;
        }
        IParameter item = this.parameters.get(index);
        return item.doesExist() ? item.getValue() : -1;
    }
}

