/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.buttons;

import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLTemporaryButtonMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.utils.ButtonEvent;

public class XLScenesMode
extends XLTemporaryButtonMode {
    public XLScenesMode(LaunchControlXLControlSurface surface, IModel model) {
        super("Select Scene", surface, model);
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        boolean isDown;
        if (row != 0 || event == ButtonEvent.LONG) {
            return;
        }
        IScene item = (IScene)this.model.getSceneBank().getItem(index);
        if (!item.doesExist()) {
            return;
        }
        boolean bl = isDown = event == ButtonEvent.DOWN;
        if (isDown) {
            this.setHasBeenUsed();
            item.select();
        }
        item.launch(isDown, false);
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = buttonID.ordinal() - ButtonID.ROW2_1.ordinal();
        if (index < 0 || index >= 8) {
            return 12;
        }
        IScene item = (IScene)this.model.getSceneBank().getItem(index);
        if (!item.doesExist()) {
            return 12;
        }
        return item.isSelected() ? 62 : 29;
    }
}

