/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam;

import de.mossgrabers.framework.controller.DefaultControllerDefinition;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class MaschineJamControllerDefinition
extends DefaultControllerDefinition {
    private static final UUID EXTENSION_ID = UUID.fromString("72F32A83-A697-446B-9016-64AA3F9476E4");
    private static final String MASCHINE_JAM_PREFIX = "Maschine Jam - ";

    public MaschineJamControllerDefinition() {
        super(EXTENSION_ID, "Maschine JAM", "Native Instruments", 1, 1);
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        ArrayList<Pair<String[], String[]>> pairs = new ArrayList<Pair<String[], String[]>>();
        switch (os) {
            case MAC: 
            case MAC_ARM: {
                for (int i = 1; i <= 4; ++i) {
                    pairs.add(this.addDeviceDiscoveryPair(MASCHINE_JAM_PREFIX + i + " Input", MASCHINE_JAM_PREFIX + i + " Output"));
                }
                break;
            }
            default: {
                for (int i = 1; i <= 4; ++i) {
                    pairs.addAll(this.createDeviceDiscoveryPairs(MASCHINE_JAM_PREFIX + i));
                }
            }
        }
        return pairs;
    }
}

