/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii.controller;

import de.mossgrabers.controller.ni.kontrol.mkii.controller.IKontrolProtocolDeviceDescriptor;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class KontrolProtocolDeviceDescriptorV2
implements IKontrolProtocolDeviceDescriptor {
    private static final String KOMPLETE_KONTROL_DAW_1 = "Komplete Kontrol DAW - 1";
    private static final UUID EXTENSION_ID = UUID.fromString("91A751B5-61C8-4388-8B8B-C2F6AD05A25D");
    private static final String DEVICE_NAME = "Komplete Kontrol S-series mk2";
    private static final String[][] PORTS_WINDOWS = new String[][]{{"Komplete Kontrol DAW - 1", "KOMPLETE KONTROL - 1"}};
    private static final String[][] PORTS_MACOS = new String[][]{{"Komplete Kontrol DAW - 1", "KOMPLETE KONTROL S49 MK2 Port 1"}, {"Komplete Kontrol DAW - 1", "KOMPLETE KONTROL S49 MK2 Anschluss 1"}, {"Komplete Kontrol DAW - 1", "KOMPLETE KONTROL S61 MK2 Port 1"}, {"Komplete Kontrol DAW - 1", "KOMPLETE KONTROL S61 MK2 Anschluss 1"}, {"Komplete Kontrol DAW - 1", "KOMPLETE KONTROL S88 MK2 Port 1"}, {"Komplete Kontrol DAW - 1", "KOMPLETE KONTROL S88 MK2 Anschluss 1"}};

    @Override
    public UUID getID() {
        return EXTENSION_ID;
    }

    @Override
    public String getName() {
        return DEVICE_NAME;
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        ArrayList<Pair<String[], String[]>> midiDiscoveryPairs = new ArrayList<Pair<String[], String[]>>();
        for (String[] ports : switch (os) {
            case OperatingSystem.MAC, OperatingSystem.MAC_ARM -> PORTS_MACOS;
            case OperatingSystem.WINDOWS -> PORTS_WINDOWS;
            default -> new String[0][0];
        }) {
            midiDiscoveryPairs.add(new Pair<String[], String[]>(ports, ports));
        }
        return midiDiscoveryPairs;
    }
}

