/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.intuitiveinstruments.exquis.mode;

import de.mossgrabers.controller.intuitiveinstruments.exquis.ExquisConfiguration;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ExquisControlSurface;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.featuregroup.AbstractMode;

public class ExquisArpeggiatorMode
extends AbstractMode<ExquisControlSurface, ExquisConfiguration> {
    private final Configuration configuration;
    private final INoteRepeat noteRepeat;
    private final IHost host;

    public ExquisArpeggiatorMode(ExquisControlSurface surface, IModel model) {
        super("Arp", surface, model, false);
        this.host = ((ExquisControlSurface)this.surface).getHost();
        this.configuration = ((ExquisControlSurface)this.surface).getConfiguration();
        this.noteRepeat = ((ExquisControlSurface)this.surface).getMidiInput().getDefaultNoteInput().getNoteRepeat();
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        if (!isTouched) {
            return;
        }
        switch (index) {
            case 0: {
                this.configuration.toggleNoteRepeatActive();
                this.mvHelper.delayDisplay(() -> "Note Repeat: " + (this.configuration.isNoteRepeatActive() ? "On" : "Off"));
                break;
            }
            case 3: {
                if (!this.host.supports(Capability.NOTE_REPEAT_LATCH)) break;
                this.noteRepeat.toggleLatchActive();
            }
        }
    }

    @Override
    public void onKnobValue(int index, int value) {
        IValueChanger valueChanger = this.model.getValueChanger();
        boolean isInc = valueChanger.isIncrease(value);
        switch (index) {
            case 0: {
                int sel = Resolution.change(Resolution.getMatch(this.configuration.getNoteRepeatPeriod().getValue()), isInc);
                this.configuration.setNoteRepeatPeriod(Resolution.values()[sel]);
                this.mvHelper.delayDisplay(() -> "Period: " + this.configuration.getNoteRepeatPeriod().getName());
                break;
            }
            case 1: {
                if (!this.host.supports(Capability.NOTE_REPEAT_LENGTH)) break;
                int sel2 = Resolution.change(Resolution.getMatch(this.configuration.getNoteRepeatLength().getValue()), valueChanger.calcKnobChange(value) > 0.0);
                this.configuration.setNoteRepeatLength(Resolution.values()[sel2]);
                this.mvHelper.delayDisplay(() -> "Length: " + this.configuration.getNoteRepeatLength().getName());
                break;
            }
            case 2: {
                if (!this.host.supports(Capability.NOTE_REPEAT_MODE)) break;
                this.configuration.setPrevNextNoteRepeatMode(valueChanger.isIncrease(value));
                this.mvHelper.delayDisplay(() -> "Mode: " + this.configuration.getNoteRepeatMode().getName());
                break;
            }
            case 3: {
                if (!this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) break;
                this.configuration.setNoteRepeatOctave(this.configuration.getNoteRepeatOctave() + (valueChanger.calcKnobChange(value) > 0.0 ? 1 : -1));
                this.mvHelper.delayDisplay(() -> "Octave: " + this.configuration.getNoteRepeatOctave());
                break;
            }
            default: {
                return;
            }
        }
    }
}

