/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.parameter.IParameter;

public class TrackRemotesHandler
extends AbstractHandler {
    public TrackRemotesHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.TRACK_SET_PARAMETER_1, FlexiCommand.TRACK_SET_PARAMETER_2, FlexiCommand.TRACK_SET_PARAMETER_3, FlexiCommand.TRACK_SET_PARAMETER_4, FlexiCommand.TRACK_SET_PARAMETER_5, FlexiCommand.TRACK_SET_PARAMETER_6, FlexiCommand.TRACK_SET_PARAMETER_7, FlexiCommand.TRACK_SET_PARAMETER_8, FlexiCommand.TRACK_SELECT_PREVIOUS_PAGE, FlexiCommand.TRACK_SELECT_NEXT_PAGE, FlexiCommand.TRACK_SELECT_PARAMETER_PAGE_1, FlexiCommand.TRACK_SELECT_PARAMETER_PAGE_2, FlexiCommand.TRACK_SELECT_PARAMETER_PAGE_3, FlexiCommand.TRACK_SELECT_PARAMETER_PAGE_4, FlexiCommand.TRACK_SELECT_PARAMETER_PAGE_5, FlexiCommand.TRACK_SELECT_PARAMETER_PAGE_6, FlexiCommand.TRACK_SELECT_PARAMETER_PAGE_7, FlexiCommand.TRACK_SELECT_PARAMETER_PAGE_8, FlexiCommand.TRACK_SCROLL_PARAMETER_PAGES, FlexiCommand.TRACK_SELECT_PREVIOUS_PARAMETER_BANK, FlexiCommand.TRACK_SELECT_NEXT_PARAMETER_BANK, FlexiCommand.TRACK_SCROLL_PARAMETER_BANKS, FlexiCommand.TRACK_TOGGLE_PARAMETER_1, FlexiCommand.TRACK_TOGGLE_PARAMETER_2, FlexiCommand.TRACK_TOGGLE_PARAMETER_3, FlexiCommand.TRACK_TOGGLE_PARAMETER_4, FlexiCommand.TRACK_TOGGLE_PARAMETER_5, FlexiCommand.TRACK_TOGGLE_PARAMETER_6, FlexiCommand.TRACK_TOGGLE_PARAMETER_7, FlexiCommand.TRACK_TOGGLE_PARAMETER_8, FlexiCommand.TRACK_RESET_PARAMETER_1, FlexiCommand.TRACK_RESET_PARAMETER_2, FlexiCommand.TRACK_RESET_PARAMETER_3, FlexiCommand.TRACK_RESET_PARAMETER_4, FlexiCommand.TRACK_RESET_PARAMETER_5, FlexiCommand.TRACK_RESET_PARAMETER_6, FlexiCommand.TRACK_RESET_PARAMETER_7, FlexiCommand.TRACK_RESET_PARAMETER_8};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        IParameterBank trackParameterBank = this.model.getCursorTrack().getParameterBank();
        if (trackParameterBank == null) {
            return -1;
        }
        switch (command) {
            case TRACK_SET_PARAMETER_1: 
            case TRACK_SET_PARAMETER_2: 
            case TRACK_SET_PARAMETER_3: 
            case TRACK_SET_PARAMETER_4: 
            case TRACK_SET_PARAMETER_5: 
            case TRACK_SET_PARAMETER_6: 
            case TRACK_SET_PARAMETER_7: 
            case TRACK_SET_PARAMETER_8: {
                return ((IParameter)trackParameterBank.getItem(command.ordinal() - FlexiCommand.TRACK_SET_PARAMETER_1.ordinal())).getValue();
            }
            case TRACK_TOGGLE_PARAMETER_1: 
            case TRACK_TOGGLE_PARAMETER_2: 
            case TRACK_TOGGLE_PARAMETER_3: 
            case TRACK_TOGGLE_PARAMETER_4: 
            case TRACK_TOGGLE_PARAMETER_5: 
            case TRACK_TOGGLE_PARAMETER_6: 
            case TRACK_TOGGLE_PARAMETER_7: 
            case TRACK_TOGGLE_PARAMETER_8: {
                int value = ((IParameter)trackParameterBank.getItem(command.ordinal() - FlexiCommand.TRACK_TOGGLE_PARAMETER_1.ordinal())).getValue();
                return TrackRemotesHandler.toMidiValue(value > 0);
            }
            case TRACK_SELECT_PARAMETER_PAGE_1: 
            case TRACK_SELECT_PARAMETER_PAGE_2: 
            case TRACK_SELECT_PARAMETER_PAGE_3: 
            case TRACK_SELECT_PARAMETER_PAGE_4: 
            case TRACK_SELECT_PARAMETER_PAGE_5: 
            case TRACK_SELECT_PARAMETER_PAGE_6: 
            case TRACK_SELECT_PARAMETER_PAGE_7: 
            case TRACK_SELECT_PARAMETER_PAGE_8: {
                return ((IParameter)trackParameterBank.getItem(command.ordinal() - FlexiCommand.TRACK_SELECT_PARAMETER_PAGE_1.ordinal())).isSelected() ? 127 : 0;
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        IParameterBank trackParameterBank = this.model.getCursorTrack().getParameterBank();
        if (trackParameterBank == null) {
            return;
        }
        switch (command) {
            case TRACK_SET_PARAMETER_1: 
            case TRACK_SET_PARAMETER_2: 
            case TRACK_SET_PARAMETER_3: 
            case TRACK_SET_PARAMETER_4: 
            case TRACK_SET_PARAMETER_5: 
            case TRACK_SET_PARAMETER_6: 
            case TRACK_SET_PARAMETER_7: 
            case TRACK_SET_PARAMETER_8: {
                IParameter trackParam = (IParameter)trackParameterBank.getItem(command.ordinal() - FlexiCommand.TRACK_SET_PARAMETER_1.ordinal());
                int val = value.getValue();
                if (TrackRemotesHandler.isAbsolute(knobMode)) {
                    trackParam.setValue(this.getAbsoluteValueChanger(value), val);
                    break;
                }
                trackParam.changeValue(this.getRelativeValueChanger(knobMode), val);
                break;
            }
            case TRACK_RESET_PARAMETER_1: 
            case TRACK_RESET_PARAMETER_2: 
            case TRACK_RESET_PARAMETER_3: 
            case TRACK_RESET_PARAMETER_4: 
            case TRACK_RESET_PARAMETER_5: 
            case TRACK_RESET_PARAMETER_6: 
            case TRACK_RESET_PARAMETER_7: 
            case TRACK_RESET_PARAMETER_8: {
                if (!this.isButtonPressed(knobMode, value)) break;
                ((IParameter)trackParameterBank.getItem(command.ordinal() - FlexiCommand.TRACK_RESET_PARAMETER_1.ordinal())).resetValue();
                break;
            }
            case TRACK_TOGGLE_PARAMETER_1: 
            case TRACK_TOGGLE_PARAMETER_2: 
            case TRACK_TOGGLE_PARAMETER_3: 
            case TRACK_TOGGLE_PARAMETER_4: 
            case TRACK_TOGGLE_PARAMETER_5: 
            case TRACK_TOGGLE_PARAMETER_6: 
            case TRACK_TOGGLE_PARAMETER_7: 
            case TRACK_TOGGLE_PARAMETER_8: {
                IParameter trackToggleParam = (IParameter)trackParameterBank.getItem(command.ordinal() - FlexiCommand.TRACK_TOGGLE_PARAMETER_1.ordinal());
                if (!this.isButtonPressed(knobMode, value)) break;
                int v = trackToggleParam.getValue();
                trackToggleParam.setValue(v > 0 ? 0 : this.model.getValueChanger().getUpperBound() - 1);
                break;
            }
            case TRACK_SELECT_PREVIOUS_PAGE: {
                if (!this.isButtonPressed(knobMode, value)) break;
                trackParameterBank.scrollBackwards();
                this.mvHelper.notifySelectedTrackParameterPage();
                break;
            }
            case TRACK_SELECT_NEXT_PAGE: {
                if (!this.isButtonPressed(knobMode, value)) break;
                trackParameterBank.scrollForwards();
                this.mvHelper.notifySelectedTrackParameterPage();
                break;
            }
            case TRACK_SELECT_PARAMETER_PAGE_1: 
            case TRACK_SELECT_PARAMETER_PAGE_2: 
            case TRACK_SELECT_PARAMETER_PAGE_3: 
            case TRACK_SELECT_PARAMETER_PAGE_4: 
            case TRACK_SELECT_PARAMETER_PAGE_5: 
            case TRACK_SELECT_PARAMETER_PAGE_6: 
            case TRACK_SELECT_PARAMETER_PAGE_7: 
            case TRACK_SELECT_PARAMETER_PAGE_8: {
                if (!this.isButtonPressed(knobMode, value)) break;
                trackParameterBank.getPageBank().selectPage(command.ordinal() - FlexiCommand.TRACK_SELECT_PARAMETER_PAGE_1.ordinal());
                this.mvHelper.notifySelectedDeviceAndParameterPage();
                break;
            }
            case TRACK_SCROLL_PARAMETER_PAGES: {
                this.scrollParameterPage(knobMode, value);
                break;
            }
            case TRACK_SELECT_PREVIOUS_PARAMETER_BANK: {
                if (!this.isButtonPressed(knobMode, value)) break;
                trackParameterBank.selectPreviousPage();
                break;
            }
            case TRACK_SELECT_NEXT_PARAMETER_BANK: {
                if (!this.isButtonPressed(knobMode, value)) break;
                trackParameterBank.selectNextPage();
                break;
            }
            case TRACK_SCROLL_PARAMETER_BANKS: {
                this.scrollParameterBank(knobMode, value);
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    private void scrollParameterPage(KnobMode knobMode, MidiValue value) {
        if (TrackRemotesHandler.isAbsolute(knobMode) || !this.increaseKnobMovement()) {
            return;
        }
        IParameterBank trackParameterBank = this.model.getCursorTrack().getParameterBank();
        if (this.isIncrease(knobMode, value)) {
            trackParameterBank.scrollForwards();
        } else {
            trackParameterBank.scrollBackwards();
        }
        this.mvHelper.notifySelectedParameterPage();
    }

    private void scrollParameterBank(KnobMode knobMode, MidiValue value) {
        if (TrackRemotesHandler.isAbsolute(knobMode) || !this.increaseKnobMovement()) {
            return;
        }
        IParameterBank trackParameterBank = this.model.getCursorTrack().getParameterBank();
        if (this.isIncrease(knobMode, value)) {
            trackParameterBank.selectNextPage();
        } else {
            trackParameterBank.selectPreviousPage();
        }
        this.mvHelper.notifySelectedParameterPage();
    }
}

