/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import java.util.ArrayList;
import java.util.List;

public class ModesHandler
extends AbstractHandler {
    private static final List<Modes> MODE_IDS = new ArrayList<Modes>();
    private final ModeManager modeManager;
    private final IHost host;

    public ModesHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger, IHost host) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
        this.host = host;
        this.modeManager = this.surface.getModeManager();
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.MODES_KNOB1, FlexiCommand.MODES_KNOB2, FlexiCommand.MODES_KNOB3, FlexiCommand.MODES_KNOB4, FlexiCommand.MODES_KNOB5, FlexiCommand.MODES_KNOB6, FlexiCommand.MODES_KNOB7, FlexiCommand.MODES_KNOB8, FlexiCommand.MODES_BUTTON1, FlexiCommand.MODES_BUTTON2, FlexiCommand.MODES_BUTTON3, FlexiCommand.MODES_BUTTON4, FlexiCommand.MODES_BUTTON5, FlexiCommand.MODES_BUTTON6, FlexiCommand.MODES_BUTTON7, FlexiCommand.MODES_BUTTON8, FlexiCommand.MODES_NEXT_ITEM, FlexiCommand.MODES_PREV_ITEM, FlexiCommand.MODES_NEXT_PAGE, FlexiCommand.MODES_PREV_PAGE, FlexiCommand.MODES_SELECT_MODE_TRACK, FlexiCommand.MODES_SELECT_MODE_VOLUME, FlexiCommand.MODES_SELECT_MODE_PAN, FlexiCommand.MODES_SELECT_MODE_SEND1, FlexiCommand.MODES_SELECT_MODE_SEND2, FlexiCommand.MODES_SELECT_MODE_SEND3, FlexiCommand.MODES_SELECT_MODE_SEND4, FlexiCommand.MODES_SELECT_MODE_SEND5, FlexiCommand.MODES_SELECT_MODE_SEND6, FlexiCommand.MODES_SELECT_MODE_SEND7, FlexiCommand.MODES_SELECT_MODE_SEND8, FlexiCommand.MODES_SELECT_MODE_DEVICE, FlexiCommand.MODES_SELECT_MODE_NEXT, FlexiCommand.MODES_SELECT_MODE_PREV, FlexiCommand.MODES_BROWSE_PRESETS};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        IMode mode = (IMode)this.modeManager.getActive();
        switch (command) {
            case MODES_KNOB1: 
            case MODES_KNOB2: 
            case MODES_KNOB3: 
            case MODES_KNOB4: 
            case MODES_KNOB5: 
            case MODES_KNOB6: 
            case MODES_KNOB7: 
            case MODES_KNOB8: {
                return mode.getKnobValue(command.ordinal() - FlexiCommand.MODES_KNOB1.ordinal());
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        IMode mode = (IMode)this.modeManager.getActive();
        if (mode == null) {
            return;
        }
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        switch (command) {
            case MODES_KNOB1: 
            case MODES_KNOB2: 
            case MODES_KNOB3: 
            case MODES_KNOB4: 
            case MODES_KNOB5: 
            case MODES_KNOB6: 
            case MODES_KNOB7: 
            case MODES_KNOB8: {
                this.changeModeValue(knobMode, command.ordinal() - FlexiCommand.MODES_KNOB1.ordinal(), value);
                break;
            }
            case MODES_BUTTON1: 
            case MODES_BUTTON2: 
            case MODES_BUTTON3: 
            case MODES_BUTTON4: 
            case MODES_BUTTON5: 
            case MODES_BUTTON6: 
            case MODES_BUTTON7: 
            case MODES_BUTTON8: {
                if (!isButtonPressed) break;
                mode.selectItem(command.ordinal() - FlexiCommand.MODES_BUTTON1.ordinal());
                this.mvHelper.notifySelectedItem(mode);
                break;
            }
            case MODES_NEXT_ITEM: {
                if (!isButtonPressed) break;
                mode.selectNextItem();
                this.mvHelper.notifySelectedItem(mode);
                break;
            }
            case MODES_PREV_ITEM: {
                if (!isButtonPressed) break;
                mode.selectPreviousItem();
                this.mvHelper.notifySelectedItem(mode);
                break;
            }
            case MODES_NEXT_PAGE: {
                if (!isButtonPressed) break;
                mode.selectNextItemPage();
                this.mvHelper.notifySelectedItem(mode);
                break;
            }
            case MODES_PREV_PAGE: {
                if (!isButtonPressed) break;
                mode.selectPreviousItemPage();
                this.mvHelper.notifySelectedItem(mode);
                break;
            }
            case MODES_SELECT_MODE_TRACK: {
                if (!isButtonPressed) break;
                this.surface.activateMode(Modes.TRACK);
                break;
            }
            case MODES_SELECT_MODE_VOLUME: {
                if (!isButtonPressed) break;
                this.surface.activateMode(Modes.VOLUME);
                break;
            }
            case MODES_SELECT_MODE_PAN: {
                if (!isButtonPressed) break;
                this.surface.activateMode(Modes.PAN);
                break;
            }
            case MODES_SELECT_MODE_SEND1: {
                if (!isButtonPressed) break;
                this.surface.activateMode(Modes.SEND1);
                break;
            }
            case MODES_SELECT_MODE_SEND2: {
                if (!isButtonPressed) break;
                this.surface.activateMode(Modes.SEND2);
                break;
            }
            case MODES_SELECT_MODE_SEND3: {
                if (!isButtonPressed) break;
                this.surface.activateMode(Modes.SEND3);
                break;
            }
            case MODES_SELECT_MODE_SEND4: {
                if (!isButtonPressed) break;
                this.surface.activateMode(Modes.SEND4);
                break;
            }
            case MODES_SELECT_MODE_SEND5: {
                if (!isButtonPressed) break;
                this.surface.activateMode(Modes.SEND5);
                break;
            }
            case MODES_SELECT_MODE_SEND6: {
                if (!isButtonPressed) break;
                this.surface.activateMode(Modes.SEND6);
                break;
            }
            case MODES_SELECT_MODE_SEND7: {
                if (!isButtonPressed) break;
                this.surface.activateMode(Modes.SEND7);
                break;
            }
            case MODES_SELECT_MODE_SEND8: {
                if (!isButtonPressed) break;
                this.surface.activateMode(Modes.SEND8);
                break;
            }
            case MODES_SELECT_MODE_DEVICE: {
                if (!isButtonPressed) break;
                this.surface.activateMode(Modes.DEVICE_PARAMS);
                break;
            }
            case MODES_SELECT_MODE_NEXT: {
                if (!isButtonPressed) break;
                this.selectNextMode();
                break;
            }
            case MODES_SELECT_MODE_PREV: {
                if (!isButtonPressed) break;
                this.selectPreviousMode();
                break;
            }
            case MODES_BROWSE_PRESETS: {
                if (!isButtonPressed) break;
                this.model.getBrowser().replace(this.model.getCursorDevice());
                this.host.scheduleTask(() -> this.surface.activateMode(Modes.BROWSER), 500L);
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeModeValue(KnobMode knobMode, int knobIndex, MidiValue value) {
        IMode mode = (IMode)this.modeManager.getActive();
        boolean absolute = ModesHandler.isAbsolute(knobMode);
        IMode iMode = mode;
        synchronized (iMode) {
            if (mode instanceof AbstractParameterMode) {
                AbstractParameterMode abstractMode = (AbstractParameterMode)mode;
                abstractMode.setAbsolute(absolute);
            }
            if (absolute) {
                mode.onKnobValue(knobIndex, value.getUpscaled());
            } else {
                IValueChanger relativeValueChanger = this.getRelativeValueChanger(knobMode);
                int control = this.model.getValueChanger().encode(relativeValueChanger.decode(value.getValue()));
                mode.onKnobValue(knobIndex, control);
            }
        }
    }

    private void selectPreviousMode() {
        Modes newMode;
        int newModeID;
        ITrackBank trackBank = this.model.getTrackBank();
        Modes activeModeId = (Modes)((Object)this.modeManager.getActiveID());
        int index = MODE_IDS.indexOf((Object)activeModeId);
        do {
            if (--index >= 0 && index < MODE_IDS.size()) continue;
            index = MODE_IDS.size() - 1;
        } while ((newModeID = (newMode = MODE_IDS.get(index)).ordinal()) >= Modes.SEND1.ordinal() && newModeID <= Modes.SEND8.ordinal() && !trackBank.canEditSend(newModeID - Modes.SEND1.ordinal()));
        this.surface.activateMode(newMode);
    }

    private void selectNextMode() {
        Modes newMode;
        int newModeID;
        ITrackBank trackBank = this.model.getTrackBank();
        Modes activeModeId = (Modes)((Object)this.modeManager.getActiveID());
        int index = MODE_IDS.indexOf((Object)activeModeId);
        do {
            if (++index >= 0 && index < MODE_IDS.size()) continue;
            index = 0;
        } while ((newModeID = (newMode = MODE_IDS.get(index)).ordinal()) >= Modes.SEND1.ordinal() && newModeID <= Modes.SEND8.ordinal() && !trackBank.canEditSend(newModeID - Modes.SEND1.ordinal()));
        this.surface.activateMode(newMode);
    }

    static {
        MODE_IDS.add(Modes.TRACK);
        MODE_IDS.add(Modes.VOLUME);
        MODE_IDS.add(Modes.PAN);
        MODE_IDS.add(Modes.SEND1);
        MODE_IDS.add(Modes.SEND2);
        MODE_IDS.add(Modes.SEND3);
        MODE_IDS.add(Modes.SEND4);
        MODE_IDS.add(Modes.SEND5);
        MODE_IDS.add(Modes.SEND6);
        MODE_IDS.add(Modes.SEND7);
        MODE_IDS.add(Modes.SEND8);
        MODE_IDS.add(Modes.DEVICE_PARAMS);
    }
}

