/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.faderfox.ec4.mode;

import de.mossgrabers.controller.faderfox.ec4.controller.EC4ControlSurface;
import de.mossgrabers.controller.faderfox.ec4.mode.AbstractEC4Mode;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.daw.data.empty.EmptyTrack;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameter.MuteParameter;
import de.mossgrabers.framework.parameter.SoloParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.RangeFilterParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SelectedTrackParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.Optional;

public class EC4ParametersMode
extends AbstractEC4Mode<IParameter> {
    private static final String[] PARAM_MODES = new String[]{"Project", "Track", "Selected Device"};
    private final IParameterBank[] banks = new IParameterBank[3];
    private final IParameterProvider[] providers = new IParameterProvider[3];
    private int selectedParam = 0;

    public EC4ParametersMode(EC4ControlSurface surface, IModel model) {
        super("Parameters", surface, model, null);
        this.banks[0] = this.model.getProject().getParameterBank();
        this.banks[1] = this.model.getCursorTrack().getParameterBank();
        this.banks[2] = this.model.getCursorDevice().getParameterBank();
        this.switchBanks(this.banks[0]);
        SelectedTrackParameterProvider trackProvider = new SelectedTrackParameterProvider(model);
        CombinedParameterProvider selTrackProvider = new CombinedParameterProvider(new RangeFilterParameterProvider(trackProvider, 0, 2), new FixedParameterProvider(new MuteParameter(model)), new FixedParameterProvider(new SoloParameter(model)));
        for (int i = 0; i < 3; ++i) {
            this.providers[i] = new CombinedParameterProvider(selTrackProvider, new BankParameterProvider(this.banks[i]), this.bottomRowProvider);
        }
        this.setParameterProvider(this.providers[0]);
    }

    @Override
    public void onButton(int row, int column, ButtonEvent event) {
        if (!this.isSession && row < 3) {
            if (event != ButtonEvent.DOWN) {
                return;
            }
            if (row == 0) {
                if (((EC4ControlSurface)this.surface).isShiftPressed()) {
                    Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
                    if (selectedTrack.isEmpty()) {
                        return;
                    }
                    switch (column) {
                        case 0: {
                            ((ITrack)selectedTrack.get()).resetVolume();
                            break;
                        }
                        case 1: {
                            ((ITrack)selectedTrack.get()).resetPan();
                            break;
                        }
                        case 2: {
                            ((ITrack)selectedTrack.get()).setMute(false);
                            break;
                        }
                        case 3: {
                            ((ITrack)selectedTrack.get()).setSolo(false);
                        }
                    }
                    return;
                }
                if (column < 3) {
                    this.selectedParam = column;
                    this.switchBanks(this.banks[this.selectedParam]);
                    this.setParameterProvider(this.providers[this.selectedParam]);
                    this.bindControls();
                    this.model.getHost().showNotification(PARAM_MODES[this.selectedParam]);
                } else {
                    this.model.getCursorDevice().toggleWindowOpen();
                }
            } else {
                int index = (row - 1) * 4 + column;
                if (((EC4ControlSurface)this.surface).isShiftPressed()) {
                    IDevice device = (IDevice)this.model.getCursorDevice().getDeviceBank().getItem(index);
                    if (device.doesExist()) {
                        device.select();
                    }
                } else {
                    IParameterPageBank pageBank = ((IParameterBank)this.getBank()).getPageBank();
                    pageBank.selectPage(index);
                    this.model.getHost().showNotification((String)pageBank.getItem(index));
                }
            }
            return;
        }
        super.onButton(row, column, event);
    }

    @Override
    public void updateDisplay() {
        IParameterBank paramBank;
        IParameterPageBank pageBank;
        Optional selectedPage;
        ArrayList<String[]> totalDisplayInfo = new ArrayList<String[]>();
        ITextDisplay display = ((EC4ControlSurface)this.surface).getTextDisplay().clear();
        display.setCell(0, 0, "Vol ").setCell(0, 1, "Pan ").setCell(0, 2, "Mute").setCell(0, 3, "Solo");
        Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
        ITrack track = EmptyTrack.getInstance(8);
        Object trackName = "";
        if (selectedTrack.isPresent()) {
            track = (ITrack)selectedTrack.get();
            trackName = track.getPosition() + 1 + ": " + track.getName();
            this.updateCache(0, track.getVolume(), totalDisplayInfo, new String[]{trackName, "", "Volume: " + track.getVolumeStr()});
            this.updateCache(1, track.getPan(), totalDisplayInfo, new String[]{trackName, "", "Pan: " + track.getPanStr()});
            this.updateCache(2, track.isMute() ? 127 : 0, totalDisplayInfo, new String[]{trackName, "", "Mute: " + (track.isMute() ? "on" : "off")});
            this.updateCache(3, track.isSolo() ? 127 : 0, totalDisplayInfo, new String[]{trackName, "", "Solo: " + (track.isSolo() ? "on" : "off")});
        }
        if (this.selectedParam == 0) {
            trackName = "   Project";
        }
        String pageName = (selectedPage = (pageBank = (paramBank = (IParameterBank)this.getBank()).getPageBank()).getSelectedItem()).isPresent() ? pageBank.getSelectedItemIndex() + 1 + ": " + (String)selectedPage.get() : "";
        for (int i = 0; i < 8; ++i) {
            IParameter param = (IParameter)paramBank.getItem(i);
            display.setCell(1 + i / 4, i % 4, param.getName(4));
            String label = param.doesExist() ? param.getName() + ": " : "None";
            String valueStr = param.getDisplayedValue();
            int longer = label.length() + valueStr.length() - 17;
            if (longer > 0) {
                label = StringUtils.shortenAndFixASCII(label, Math.max(2, label.length() - longer));
            }
            this.updateCache(4 + i, param.getValue(), totalDisplayInfo, new String[]{trackName, pageName, i + 1 + ": " + label + valueStr});
        }
        super.updateDisplayRow4(display, totalDisplayInfo, "Main");
        display.allDone();
        ((EC4ControlSurface)this.surface).fillTotalDisplay(totalDisplayInfo);
    }
}

