/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.electra.one.mode;

import de.mossgrabers.controller.electra.one.controller.ElectraOneColorManager;
import de.mossgrabers.controller.electra.one.controller.ElectraOneControlSurface;
import de.mossgrabers.controller.electra.one.mode.AbstractElectraOneMode;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.empty.EmptyTrack;
import de.mossgrabers.framework.parameter.PlayPositionParameter;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.EmptyParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SendParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Optional;

public class SendsMode
extends AbstractElectraOneMode {
    private static final int FIRST_TRACK_GROUP = 510;
    private final ITransport transport;
    private final IMasterTrack masterTrack;

    public SendsMode(ElectraOneControlSurface surface, IModel model) {
        super(1, "Sends", surface, model);
        this.transport = this.model.getTransport();
        this.masterTrack = this.model.getMasterTrack();
        this.setParameterProvider(new CombinedParameterProvider(new SendParameterProvider(model, 0, 0), new FixedParameterProvider(this.masterTrack.getVolumeParameter()), new SendParameterProvider(model, 1, 0), new FixedParameterProvider(new PlayPositionParameter(model.getValueChanger(), this.transport, surface)), new SendParameterProvider(model, 2, 0), new EmptyParameterProvider(1), new SendParameterProvider(model, 3, 0), new EmptyParameterProvider(1), new SendParameterProvider(model, 4, 0), new EmptyParameterProvider(1), new SendParameterProvider(model, 5, 0), new EmptyParameterProvider(1)));
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN || index != 5) {
            return;
        }
        switch (row) {
            case 2: {
                this.model.getCurrentTrackBank().selectNextPage();
                break;
            }
            case 3: {
                this.model.getCurrentTrackBank().selectPreviousPage();
                break;
            }
            case 4: {
                this.transport.startRecording();
                break;
            }
            case 5: {
                this.playCommand.execute(ButtonEvent.UP, 127);
                break;
            }
        }
    }

    @Override
    public void updateDisplay() {
        for (int column = 0; column < 5; ++column) {
            Optional<ITrack> trackOpt = this.getTrack(column);
            ITrack track = trackOpt.isPresent() ? trackOpt.get() : EmptyTrack.getInstance(((ITrack)this.model.getTrackBank().getItem(0)).getSendBank().getPageSize());
            ColorEx color = track.getColor();
            this.pageCache.updateGroupLabel(510 + column, (String)(track.doesExist() ? track.getPosition() + 1 + ": " + track.getName() : ""));
            for (int row = 0; row < 6; ++row) {
                ISendBank sendBank = track.getSendBank();
                ISend send = (ISend)sendBank.getItem(row);
                boolean doesExist = send.doesExist();
                this.pageCache.updateValue(row, column, send.getValue(), doesExist ? StringUtils.optimizeName(StringUtils.fixASCII(send.getDisplayedValue()), 15) : " ");
                this.pageCache.updateElement(row, column, send.getName(), doesExist ? color : ColorEx.BLACK, doesExist);
            }
        }
        this.pageCache.updateColor(0, 5, this.masterTrack.getColor());
        this.pageCache.updateValue(0, 5, this.masterTrack.getVolume(), StringUtils.optimizeName(StringUtils.fixASCII(this.masterTrack.getVolumeStr()), 15));
        this.pageCache.updateValue(1, 5, 0, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getBeatText()), 15));
        this.pageCache.updateElement(1, 5, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getPositionText()), 15), null, null);
        this.pageCache.updateColor(4, 5, this.transport.isRecording() ? ElectraOneColorManager.RECORD_ON : ElectraOneColorManager.RECORD_OFF);
        this.pageCache.updateColor(5, 5, this.transport.isPlaying() ? ElectraOneColorManager.PLAY_ON : ElectraOneColorManager.PLAY_OFF);
        this.pageCache.flush();
    }
}

