/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.electra.one;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IActionSetting;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import java.util.Arrays;
import java.util.List;

public class ElectraOneConfiguration
extends AbstractConfiguration {
    public static final Integer KNOB_TOUCH_COMBINATION_COMMANDS = 100;
    private static final String CATEGORY_ASSIGNABLE_BUTTONS = "Assignable button touches";
    private static final String[] ASSIGNABLE_VALUES = new String[]{"Off", "Shift Button", "Mode: Mixer", "Mode: Sends", "Mode: Device", "Mode: EQ", "Mode: Transport", "Mode: Session", "Mode: Project/Track Parameters", "Mode: Select Synth Preset", "Function: Toggle Play", "Function: Toggle Record", "Function: Stop All Clips", "Function: Toggle Clip Overdub", "Function: Undo", "Function: Tap Tempo", "Function: New Button", "Function: Clip Based Looper", "Function: Panel layout arrange", "Function: Panel layout mix", "Function: Panel layout edit", "Function: Add instrument track", "Function: Add audio track", "Function: Add effect track", "Function: Quantize", "Action"};
    public static final int ELECTRA_ONE_FUNC_OFF = 0;
    public static final int ELECTRA_ONE_FUNC_SHIFT_BUTTON = 1;
    public static final int ELECTRA_ONE_FUNC_MODE_MIXER = 2;
    public static final int ELECTRA_ONE_FUNC_MODE_SENDS = 3;
    public static final int ELECTRA_ONE_FUNC_MODE_DEVICE = 4;
    public static final int ELECTRA_ONE_FUNC_MODE_EQ = 5;
    public static final int ELECTRA_ONE_FUNC_MODE_TRANSPORT = 6;
    public static final int ELECTRA_ONE_FUNC_MODE_SESSION = 7;
    public static final int ELECTRA_ONE_FUNC_MODE_PARAMS = 8;
    public static final int ELECTRA_ONE_FUNC_MODE_SYNTH_PRESET = 9;
    public static final int ELECTRA_ONE_FUNC_MODE_ACTION = 25;
    private static final int FOOTSWITCH_CMDS_OFFSET = 10;
    private static final int[] ASSIGNABLE_BUTTON_DEFAULTS = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 10, 11, 12, 14};
    private static final String[] ASSIGNABLE_BUTTON_NAMES = new String[]{"Linear 1 - 3", "Linear 2 - 4", "Linear 3 - 5", "Linear 4 - 6", "Linear 7 - 9", "Linear 8 - 10", "Linear 9 - 11", "Linear 10 - 12", "Linear Left 1, 2, 4", "Linear Left 2, 3, 5", "Linear Left 3, 4, 6", "Linear Left 7, 8, 10", "Linear Left 8, 9, 11", "Linear Left 9, 10, 12", "Linear Right 1, 3, 4", "Linear Right 2, 4, 5", "Linear Right 3, 5, 6", "Linear Right 7, 9, 10", "Linear Right 8, 10, 11", "Linear Right 9, 11, 12", "Linear Broad 1, 3, 5", "Linear Broad 2, 4, 6", "Linear Broad 7, 9, 11", "Linear Broad 8, 10, 12", "Corner Left 1, 2, 7", "Corner Left 2, 3, 8", "Corner Left 3, 4, 9", "Corner Left 4, 5, 10", "Corner Left 5, 6, 11", "Corner Right 1, 2, 8", "Corner Right 2, 3, 9", "Corner Right 3, 4, 10", "Corner Right 4, 5, 11", "Corner Right 5, 6, 12", "Triangle 2, 7, 9", "Triangle 3, 8, 10", "Triangle 4, 9, 11", "Triangle 5, 10, 12"};
    public static final Integer LOG_TO_CONSOLE = 50;
    private boolean isLogToConsoleEnabled = false;
    private final int[] assignableFunctions = new int[ASSIGNABLE_BUTTON_NAMES.length];
    private final String[] assignableFunctionActions = new String[ASSIGNABLE_BUTTON_NAMES.length];

    public ElectraOneConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
        Arrays.fill(this.assignableFunctions, 0);
        Arrays.fill(this.assignableFunctionActions, "");
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateHardwareSettings(globalSettings);
        this.activateKnobSpeedSetting(globalSettings, 100, 20);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateAssignableSettings(globalSettings);
    }

    private void activateHardwareSettings(ISettingsUI settingsUI) {
        IEnumSetting logToConsoleSetting = settingsUI.getEnumSetting("Enable Electra.One logging (written to Controller Script Console)", "Hardware Setup", ON_OFF_OPTIONS, ON_OFF_OPTIONS[0]);
        logToConsoleSetting.addValueObserver(value -> {
            this.isLogToConsoleEnabled = "On".equals(value);
            this.notifyObservers(LOG_TO_CONSOLE);
        });
        this.isSettingActive.add(LOG_TO_CONSOLE);
    }

    private void activateAssignableSettings(ISettingsUI settingsUI) {
        for (int i = 0; i < this.assignableFunctions.length; ++i) {
            int pos = i;
            IEnumSetting assignableSetting = settingsUI.getEnumSetting(ASSIGNABLE_BUTTON_NAMES[i], CATEGORY_ASSIGNABLE_BUTTONS, ASSIGNABLE_VALUES, ASSIGNABLE_VALUES[ASSIGNABLE_BUTTON_DEFAULTS[i]]);
            assignableSetting.addValueObserver(value -> {
                this.assignableFunctions[pos] = ElectraOneConfiguration.lookupIndex(ASSIGNABLE_VALUES, value);
                this.notifyObservers(KNOB_TOUCH_COMBINATION_COMMANDS);
            });
            IActionSetting actionSetting = settingsUI.getActionSetting(ASSIGNABLE_BUTTON_NAMES[i] + " - Action", CATEGORY_ASSIGNABLE_BUTTONS);
            actionSetting.addValueObserver(value -> {
                this.assignableFunctionActions[pos] = (String)actionSetting.get();
            });
        }
        this.isSettingActive.add(KNOB_TOUCH_COMBINATION_COMMANDS);
    }

    public boolean isLogToConsoleEnabled() {
        return this.isLogToConsoleEnabled;
    }

    public int getAssignable(int index) {
        return this.assignableFunctions[index];
    }

    public String getAssignableAction(int index) {
        return this.assignableFunctionActions[index];
    }
}

