/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.command.trigger;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.framework.command.trigger.transport.TapTempoCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Timeout;
import de.mossgrabers.framework.view.Views;

public class APCTapTempoCommand
extends TapTempoCommand<APCControlSurface, APCConfiguration> {
    private final Timeout timeout;

    public APCTapTempoCommand(IModel model, APCControlSurface surface) {
        super(model, surface);
        this.timeout = new Timeout(model.getHost(), 500);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        super.executeNormal(event);
        ViewManager viewManager = ((APCControlSurface)this.surface).getViewManager();
        if (!viewManager.isActive(new Views[]{Views.TEMPO})) {
            viewManager.setTemporary(Views.TEMPO);
        }
        this.timeout.delay(viewManager::restore);
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.model.getMarkerBank().addMarker();
        }
    }

    public Timeout getTimeout() {
        return this.timeout;
    }
}

