/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.view;

import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.midi.INoteRepeat;

public class NoteRepeatSceneHelper {
    private NoteRepeatSceneHelper() {
    }

    public static String getButtonColorID(PushControlSurface surface, ButtonID buttonID) {
        INoteRepeat noteRepeat = surface.getMidiInput().getDefaultNoteInput().getNoteRepeat();
        int sceneIndex = 7 - (buttonID.ordinal() - ButtonID.SCENE1.ordinal());
        if (surface.isShiftPressed()) {
            return Resolution.getMatch(noteRepeat.getNoteLength()) == sceneIndex ? "NOTE_REPEAT_LENGTH_HI" : "NOTE_REPEAT_LENGTH_OFF";
        }
        return Resolution.getMatch(noteRepeat.getPeriod()) == sceneIndex ? "NOTE_REPEAT_PERIOD_HI" : "NOTE_REPEAT_PERIOD_OFF";
    }

    public static void handleNoteRepeatSelection(PushControlSurface surface, int sceneIndex) {
        surface.setTriggerConsumed(ButtonID.REPEAT);
        INoteRepeat noteRepeat = surface.getMidiInput().getDefaultNoteInput().getNoteRepeat();
        if (surface.isShiftPressed()) {
            noteRepeat.setNoteLength(Resolution.getValueAt(sceneIndex));
        } else {
            noteRepeat.setPeriod(Resolution.getValueAt(sceneIndex));
        }
    }
}

