/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class SessionViewSelectMode
extends BaseMode<IItem> {
    private static final Views[] VIEWS = new Views[]{Views.SESSION, Views.SESSION, Views.SCENE_PLAY, null, null};
    private static final String[] VIEW_NAMES = new String[]{"Clips", "Flipped", "Scenes", "", ""};

    public SessionViewSelectMode(PushControlSurface surface, IModel model) {
        super("Session View", surface, model);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        PushConfiguration configuration = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        switch (index) {
            case 0: 
            case 1: {
                configuration.setFlipSession(index == 1);
                ((PushControlSurface)this.surface).getViewManager().setActive(VIEWS[index]);
                modeManager.restore();
                break;
            }
            case 2: {
                configuration.setSceneView();
                modeManager.restore();
                break;
            }
            case 5: {
                modeManager.setActive(Modes.SESSION);
                break;
            }
            case 6: {
                modeManager.setActive(Modes.MARKERS);
                break;
            }
            case 7: {
                modeManager.setActive(configuration.getMixerMode());
                break;
            }
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        display.setCell(0, 3, " Session");
        display.setBlock(0, 2, "configuration");
        display.setBlock(2, 0, "Pads are:");
        for (int i = 0; i < VIEWS.length; ++i) {
            if (VIEWS[i] == null) continue;
            display.setCell(3, i, (this.isSelected(viewManager, i) ? Push1Display.SELECT_ARROW : "") + VIEW_NAMES[i]);
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        display.setCell(2, 5, " Display");
        display.setCell(2, 6, "shows:");
        display.setCell(3, 5, " " + (modeManager.isActiveIgnoreTemporary(new Modes[]{Modes.SESSION}) ? Push1Display.SELECT_ARROW : "") + "Clips");
        display.setCell(3, 6, (modeManager.isActiveIgnoreTemporary(new Modes[]{Modes.MARKERS}) ? Push1Display.SELECT_ARROW : "") + "Markers");
        display.setCell(3, 7, (!modeManager.isActiveIgnoreTemporary(new Modes[]{Modes.SESSION, Modes.MARKERS}) ? Push1Display.SELECT_ARROW : "") + "Off");
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        for (int i = 0; i < VIEWS.length; ++i) {
            boolean isMenuBottomSelected = VIEWS[i] != null && this.isSelected(viewManager, i);
            display.addOptionElement(i == 0 ? "Session configuration" : "", "", false, i == 0 ? "Pads are" : "", VIEW_NAMES[i], isMenuBottomSelected, false);
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        display.addOptionElement("", "", false, "Display shows", "Scenes/Clips", modeManager.isActiveIgnoreTemporary(new Modes[]{Modes.SESSION}), false);
        display.addOptionElement("", "", false, "", "Markers", modeManager.isActiveIgnoreTemporary(new Modes[]{Modes.MARKERS}), false);
        display.addOptionElement("", "", false, "", "Off", !modeManager.isActiveIgnoreTemporary(new Modes[]{Modes.SESSION, Modes.MARKERS}), false);
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            if (index < VIEWS.length) {
                if (VIEWS[index] == null) {
                    return "BUTTON_COLOR_OFF";
                }
                ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
                return this.isSelected(viewManager, index) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
            }
            ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
            if (index == 5) {
                return modeManager.isActiveIgnoreTemporary(new Modes[]{Modes.SESSION}) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
            }
            if (index == 6) {
                return modeManager.isActiveIgnoreTemporary(new Modes[]{Modes.MARKERS}) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
            }
            if (index == 7) {
                return !modeManager.isActiveIgnoreTemporary(new Modes[]{Modes.SESSION, Modes.MARKERS}) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
            }
            return "BUTTON_COLOR_OFF";
        }
        return "BUTTON_COLOR_OFF";
    }

    private boolean isSelected(ViewManager viewManager, int index) {
        boolean activeView = viewManager.isActive(new Views[]{VIEWS[index]});
        switch (index) {
            case 0: {
                return activeView && !((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isFlipSession();
            }
            case 1: {
                return activeView && ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).isFlipSession();
            }
        }
        return activeView;
    }
}

