/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.BytesReceiver;
import com.illposed.osc.OSCSerializeException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class ByteArrayListBytesReceiver
implements BytesReceiver {
    private final List<byte[]> buffer = new LinkedList<byte[]>();
    private int pos = 0;

    @Override
    public BytesReceiver put(byte data) {
        this.buffer.add(new byte[]{data});
        ++this.pos;
        return this;
    }

    @Override
    public BytesReceiver put(byte[] src) {
        this.buffer.add(src);
        this.pos += src.length;
        return this;
    }

    @Override
    public BytesReceiver put(ByteBuffer src) {
        return this.put(src.array());
    }

    @Override
    public BytesReceiver clear() {
        this.buffer.clear();
        return this;
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public BytesReceiver.PlaceHolder putPlaceHolder(byte[] src) {
        PlaceHolderImpl placeHolder = new PlaceHolderImpl(src);
        this.put(src);
        return placeHolder;
    }

    @Override
    public byte[] toByteArray() {
        byte[] bytes = new byte[this.pos];
        int curPos = 0;
        for (byte[] curPart : this.buffer) {
            System.arraycopy(curPart, 0, bytes, curPos, curPart.length);
            curPos += curPart.length;
        }
        return bytes;
    }

    public void writeTo(OutputStream dest) throws IOException {
        for (byte[] dataPiece : this.buffer) {
            dest.write(dataPiece);
        }
    }

    private static class PlaceHolderImpl
    implements BytesReceiver.PlaceHolder {
        private final byte[] part;

        PlaceHolderImpl(byte[] part) {
            this.part = part;
        }

        @Override
        public void replace(byte[] src) throws OSCSerializeException {
            if (src.length != this.part.length) {
                throw new OSCSerializeException(String.format("Trying to replace placeholder of size %d with data of size %d", this.part.length, src.length));
            }
            System.arraycopy(src, 0, this.part, 0, src.length);
        }
    }
}

