/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.widget;

import de.mossgrabers.reaper.ui.widget.BoxPanel;
import de.mossgrabers.reaper.ui.widget.Functions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class TwoColsPanel
extends BoxPanel {
    private static final long serialVersionUID = 3618981170092914480L;
    protected BoxPanel left = new BoxPanel(1, 0.0f, false);
    protected BoxPanel right = new BoxPanel(1, 0.0f, false);

    public TwoColsPanel(boolean addBorderSpace) {
        super(1, addBorderSpace);
        this.setLayout(new BorderLayout(12, 0));
        this.add((Component)this.left, "West");
        this.add((Component)this.right, "Center");
    }

    public BoxPanel getLeft() {
        return this.left;
    }

    public BoxPanel getRight() {
        return this.right;
    }

    @Override
    public <T extends JComponent> T addComponent(T component, JLabel label, String mnemonic, String tooltip, int space, boolean addScrollPane) {
        return this.addComponent(component, label, mnemonic, tooltip, space, addScrollPane, true);
    }

    public <T extends JComponent> T addComponent(T component, JLabel label, String mnemonic, String tooltip, int space, boolean addScrollPane, boolean adjustSize) {
        JLabel l = label == null ? new JLabel("") : label;
        l.setLabelFor(component);
        if (mnemonic != null) {
            l.setDisplayedMnemonic(this.getMnemonicChar(mnemonic));
        }
        Functions.asHighAs(component, l);
        JScrollPane c = addScrollPane ? new JScrollPane(component) : component;
        this.left.addComponent(l, (JLabel)null, mnemonic, tooltip, space, false);
        this.right.addComponent(c, (JLabel)null, null, tooltip, space, false);
        if (adjustSize) {
            c.addComponentListener(new SizeAdjuster(l, c));
        }
        l.setVerticalAlignment(1);
        return component;
    }

    @Override
    public void sizeEqual(boolean isVert) {
        this.right.sizeEqual(isVert);
    }

    class SizeAdjuster
    extends ComponentAdapter {
        JLabel label;
        JComponent component;

        public SizeAdjuster(JLabel label, JComponent component) {
            this.label = label;
            this.component = component;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Dimension size = this.label.getSize();
            size.height = this.component.getSize().height;
            this.label.setMinimumSize(size);
            this.label.setPreferredSize(size);
            this.label.setMaximumSize(size);
            this.label.invalidate();
            TwoColsPanel.this.validate();
        }
    }
}

