/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.usb;

import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IMemoryBlock;
import de.mossgrabers.framework.usb.IUsbCallback;
import de.mossgrabers.framework.usb.IUsbEndpoint;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;
import org.usb4java.Transfer;

public class UsbEndpointImpl
implements IUsbEndpoint {
    private final IHost host;
    private final DeviceHandle handle;
    private final byte endpointAddress;
    private final boolean isBulk;
    private Transfer activeTransfer;
    private final Object transferLock = new Object();
    private final CountDownLatch clearLatch = new CountDownLatch(1);

    public UsbEndpointImpl(IHost host, DeviceHandle handle, byte endpointAddress, boolean isBulk) {
        this.host = host;
        this.handle = handle;
        this.endpointAddress = endpointAddress;
        this.isBulk = isBulk;
    }

    @Override
    public void send(IMemoryBlock memoryBlock, int timeout) {
        IntBuffer transfered = IntBuffer.allocate(1);
        ByteBuffer buffer = memoryBlock.createByteBuffer();
        int result = this.isBulk ? LibUsb.bulkTransfer((DeviceHandle)this.handle, (byte)this.endpointAddress, (ByteBuffer)buffer, (IntBuffer)transfered, (long)timeout) : LibUsb.interruptTransfer((DeviceHandle)this.handle, (byte)this.endpointAddress, (ByteBuffer)buffer, (IntBuffer)transfered, (long)timeout);
        if (result == 0) {
            return;
        }
        result = this.isBulk ? LibUsb.bulkTransfer((DeviceHandle)this.handle, (byte)this.endpointAddress, (ByteBuffer)buffer, (IntBuffer)transfered, (long)timeout) : LibUsb.interruptTransfer((DeviceHandle)this.handle, (byte)this.endpointAddress, (ByteBuffer)buffer, (IntBuffer)transfered, (long)timeout);
        if (result != 0) {
            this.host.error("USB transmission error: " + result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendAsync(IMemoryBlock memoryBlock, IUsbCallback callback, int timeout) {
        Object object = this.transferLock;
        synchronized (object) {
            if (this.activeTransfer != null) {
                return;
            }
            this.activeTransfer = LibUsb.allocTransfer();
        }
        if (this.isBulk) {
            LibUsb.fillBulkTransfer((Transfer)this.activeTransfer, (DeviceHandle)this.handle, (byte)this.endpointAddress, (ByteBuffer)memoryBlock.createByteBuffer(), result -> this.handleAsyncResult(callback, result), null, (long)timeout);
        } else {
            LibUsb.fillInterruptTransfer((Transfer)this.activeTransfer, (DeviceHandle)this.handle, (byte)this.endpointAddress, (ByteBuffer)memoryBlock.createByteBuffer(), result -> this.handleAsyncResult(callback, result), null, (long)timeout);
        }
        int result2 = LibUsb.submitTransfer((Transfer)this.activeTransfer);
        if (result2 != 0) {
            this.host.error("Unable to submit USB async transfer: " + result2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.transferLock;
        synchronized (object) {
            if (this.activeTransfer == null) {
                return;
            }
            int result = LibUsb.cancelTransfer((Transfer)this.activeTransfer);
            if (result != 0) {
                return;
            }
        }
        try {
            boolean await = this.clearLatch.await(10L, TimeUnit.SECONDS);
            if (!await) {
                this.host.error("Timed out waiting for LibUsb transfer cancelation.");
            }
        }
        catch (InterruptedException ex) {
            this.host.error("Thread was interrupted while waiting for LibUsb transfer cancelation.", ex);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAsyncResult(IUsbCallback callback, Transfer result) {
        int status = result.status();
        if (status == 3) {
            this.clearLatch.countDown();
            return;
        }
        if (status != 0) {
            this.host.error("USB receive error: " + status);
        }
        callback.process(status == 0 ? result.actualLength() : -1);
        LibUsb.freeTransfer((Transfer)this.activeTransfer);
        Object object = this.transferLock;
        synchronized (object) {
            this.activeTransfer = null;
        }
    }
}

