/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.bank;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.empty.EmptyDrumPad;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.DrumPadImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.AbstractPagedBankImpl;
import java.util.Optional;

public class DrumPadBankImpl
extends AbstractPagedBankImpl<DrumPadImpl, ILayer>
implements IDrumPadBank {
    private final int numSends;

    public DrumPadBankImpl(DataSetupEx dataSetup, int numLayers, int numSends) {
        super(dataSetup, numLayers, EmptyDrumPad.getInstance(numSends));
        this.numSends = numSends;
        if (numLayers == 0) {
            return;
        }
        this.setItemCount(128);
        for (int i = 0; i < 128; ++i) {
            DrumPadImpl drumPad = (DrumPadImpl)this.getUnpagedItem(i);
            drumPad.setPosition(i);
            drumPad.setIndex(numLayers > 0 ? i % numLayers : i);
            drumPad.setInternalName("Drum " + i);
        }
        this.setSelectedDrumPad(36);
        this.scrollTo(36);
    }

    @Override
    public IDrumPad getItem(int index) {
        return (IDrumPad)super.getItem(index);
    }

    @Override
    protected IDrumPad createItem(int position) {
        return new DrumPadImpl(this.dataSetup, this, position, this.numSends);
    }

    @Override
    public void setIndication(boolean shouldIndicate) {
    }

    @Override
    public String getSelectedChannelColorEntry() {
        Optional sel = this.getSelectedItem();
        if (sel.isEmpty()) {
            return DAWColor.COLOR_OFF.name();
        }
        ColorEx color = ((ILayer)sel.get()).getColor();
        return DAWColor.getColorID(color);
    }

    @Override
    public ISceneBank getSceneBank() {
        return null;
    }

    @Override
    public void clearMute() {
    }

    @Override
    public void clearSolo() {
    }

    @Override
    public boolean hasSoloedPads() {
        return false;
    }

    @Override
    public boolean hasMutedPads() {
        return false;
    }

    @Override
    public void scrollTo(int position, boolean adjustPage) {
        this.setBankOffset(position / this.pageSize * this.pageSize);
    }

    public void setSelectedDrumPad(int position) {
        for (int i = 0; i < this.itemCount; ++i) {
            ((DrumPadImpl)this.getUnpagedItem(i)).setSelected(i == position);
        }
    }

    @Override
    public boolean canEditSend(int sendIndex) {
        return false;
    }

    @Override
    public String getEditSendName(int sendIndex) {
        return "";
    }
}

