/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework;

import com.nikhaldimann.inieditor.IniEditor;
import de.mossgrabers.reaper.ui.utils.LogModel;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class IniFiles {
    private static final String OPTION_FORMAT_NO_SPACES = "%s%s%s";
    private static final String FX_TAGS = "reaper-fxtags.ini";
    private static final String FX_FOLDERS = "reaper-fxfolders.ini";
    private static final String PARAM_MAPS = "DrivenByMoss4Reaper-ParameterMaps.ini";
    private static final String REAPER_MAIN = "REAPER.ini";
    private static final String REAPER_MAIN2 = "reaper.ini";
    private final IniEditor iniFxTags = new IniEditor();
    private final IniEditor iniFxFolders = new IniEditor();
    private final IniEditor iniDeviceMaps = new IniEditor();
    private final IniEditor iniReaperMain = new IniEditor();
    private String iniPath;
    private LogModel logModel;
    private boolean isFxTagsPresent;
    private boolean isFxFoldersPresent;
    private boolean isParamMapsPresent;
    private String paramMapsFilename;
    private File reaperINIFile;
    private long reaperINILastChange = -1L;

    public IniFiles() {
        this.iniFxTags.setOptionFormatString(OPTION_FORMAT_NO_SPACES);
        this.iniFxFolders.setOptionFormatString(OPTION_FORMAT_NO_SPACES);
        this.iniDeviceMaps.setOptionFormatString(OPTION_FORMAT_NO_SPACES);
        this.iniReaperMain.setOptionFormatString(OPTION_FORMAT_NO_SPACES);
    }

    public String getIniPath() {
        return this.iniPath;
    }

    public void init(String iniPath, LogModel logModel) {
        this.iniPath = iniPath;
        this.logModel = logModel;
        this.reaperINIFile = new File(iniPath + File.separator + REAPER_MAIN);
        if (!this.reaperINIFile.exists()) {
            this.reaperINIFile = new File(iniPath + File.separator + REAPER_MAIN2);
        }
        this.loadReaperINI();
        this.isFxTagsPresent = this.loadINIFile(iniPath + File.separator + FX_TAGS, this.iniFxTags);
        this.isFxFoldersPresent = this.loadINIFile(iniPath + File.separator + FX_FOLDERS, this.iniFxFolders);
        this.paramMapsFilename = iniPath + File.separator + PARAM_MAPS;
        this.isParamMapsPresent = this.loadINIFile(this.paramMapsFilename, this.iniDeviceMaps);
    }

    public IniEditor getIniFxTags() {
        return this.iniFxTags;
    }

    public IniEditor getIniFxFolders() {
        return this.iniFxFolders;
    }

    public IniEditor getIniParamMaps() {
        return this.iniDeviceMaps;
    }

    public void storeIniParamMaps() throws IOException {
        this.iniDeviceMaps.save(this.paramMapsFilename);
    }

    public boolean isFxTagsPresent() {
        return this.isFxTagsPresent;
    }

    public boolean isFxFoldersPresent() {
        return this.isFxFoldersPresent;
    }

    public boolean isParamMapsPresent() {
        return this.isParamMapsPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMainIniInteger(String section, String option, int defaultValue) {
        String value;
        IniEditor iniEditor = this.iniReaperMain;
        synchronized (iniEditor) {
            this.loadReaperINI();
            try {
                value = this.iniReaperMain.get(section, option);
            }
            catch (IniEditor.NoSuchSectionException ex) {
                return defaultValue;
            }
        }
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadReaperINI() {
        IniEditor iniEditor = this.iniReaperMain;
        synchronized (iniEditor) {
            long modified = this.reaperINIFile.lastModified();
            if (this.reaperINILastChange != modified) {
                this.reaperINILastChange = modified;
                this.loadINIFile(this.reaperINIFile, this.iniReaperMain);
            }
        }
    }

    private boolean loadINIFile(String filename, IniEditor iniFile) {
        return this.loadINIFile(new File(filename), iniFile);
    }

    private boolean loadINIFile(File file, IniEditor iniFile) {
        try {
            if (file.exists()) {
                try (FileReader reader = new FileReader(file.getAbsolutePath(), StandardCharsets.UTF_8);){
                    iniFile.load((InputStreamReader)reader);
                }
                return true;
            }
            this.logModel.info(file.getName() + " not present (this is not an error!).");
            return false;
        }
        catch (IOException ex) {
            this.logModel.error("Could not load file: " + file.getName(), ex);
            return false;
        }
    }
}

