/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.communication;

import de.mossgrabers.reaper.communication.Processor;
import java.util.Map;

public interface BackendExchange {
    default public void processNoArg(Processor processor) {
        this.processNoArg(processor, null);
    }

    public void processNoArg(Processor var1, String var2);

    public void processStringArg(Processor var1, String var2, String var3);

    public void processStringArgs(Processor var1, String var2, String[] var3);

    default public void processIntArg(Processor processor, int value) {
        this.processIntArg(processor, null, value);
    }

    public void processIntArg(Processor var1, String var2, int var3);

    default public void processDoubleArg(Processor processor, double value) {
        this.processDoubleArg(processor, null, value);
    }

    public void processDoubleArg(Processor var1, String var2, double var3);

    default public void processBooleanArg(Processor processor, String command, boolean value) {
        this.processIntArg(processor, command, value ? 1 : 0);
    }

    public void delayUpdates(Processor var1);

    public void enableUpdates(Processor var1, boolean var2);

    public void processMidiArg(int var1, int var2, int var3, int var4);

    public void invokeAction(int var1);

    public Map<Integer, String> getMidiInputs();

    public Map<Integer, String> getMidiOutputs();

    public boolean openMidiInput(int var1);

    public boolean openMidiOutput(int var1);

    public void closeMidiInput(int var1);

    public void closeMidiOutput(int var1);

    public void sendMidiData(int var1, byte[] var2);

    public void setNoteInputFilters(int var1, int var2, String[] var3);

    public void setNoteInputKeyTranslationTable(int var1, int var2, int[] var3);

    public void setNoteInputVelocityTranslationTable(int var1, int var2, int[] var3);
}

