/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view.sequencer;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;

public class ClipLengthView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractSequencerView<S, C> {
    public static final String COLOR_OUTSIDE = "COLOR_OUTSIDE";
    public static final String COLOR_PART = "COLOR_PART";
    private static final int[] PAD_RESOLUTIONS = new int[]{1, 4, 16};
    private final ITransport transport;
    private int padResolution = 0;
    private int firstPressedPad = -1;
    private boolean hasSecondPressed = false;

    public ClipLengthView(S surface, IModel model, boolean useDawColors) {
        super("Clip Length", surface, model, 0, 0, useDawColors);
        this.transport = model.getTransport();
    }

    @Override
    public void updateNoteMapping() {
        this.delayedUpdateNoteMapping(EMPTY_TABLE);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        boolean isSecondPad;
        IPadGrid padGrid = this.surface.getPadGrid();
        int cols = padGrid.getCols();
        int index = note - 36;
        int x = index % cols;
        int y = index / cols;
        int pad = (cols - 1 - y) * cols + x;
        if (velocity > 0) {
            if (this.firstPressedPad == -1) {
                this.firstPressedPad = pad;
            }
            return;
        }
        boolean bl = isSecondPad = this.firstPressedPad != pad;
        if (isSecondPad) {
            this.hasSecondPressed = true;
        }
        if (isSecondPad || !this.hasSecondPressed) {
            int start = this.firstPressedPad < pad ? this.firstPressedPad : pad;
            int end = (this.firstPressedPad < pad ? pad : this.firstPressedPad) + 1;
            double quartersPerPad = this.getQuartersPerPad();
            double newStart = (double)start * quartersPerPad;
            INoteClip clip = this.getClip();
            clip.setLoopStart(newStart);
            clip.setLoopLength((double)(end - start) * quartersPerPad);
            clip.setPlayRange(newStart, (double)end * quartersPerPad);
        }
        if (this.firstPressedPad == pad) {
            this.firstPressedPad = -1;
            this.hasSecondPressed = false;
        }
    }

    @Override
    public void drawGrid() {
        INoteClip clip = this.getClip();
        double start = clip.getLoopStart();
        double quartersPerPad = this.getQuartersPerPad();
        double maxQuarters = quartersPerPad * 64.0;
        int loopStartPad = (int)Math.floor(Math.max(0.0, start) / quartersPerPad);
        int loopEndPad = (int)Math.ceil(Math.min(maxQuarters, start + clip.getLoopLength()) / quartersPerPad);
        String clipColor = this.useDawColors ? DAWColor.getColorID(clip.getColor()) : COLOR_PART;
        IPadGrid padGrid = this.surface.getPadGrid();
        int cols = padGrid.getCols();
        for (int pad = 0; pad < 64; ++pad) {
            padGrid.lightEx(pad % cols, pad / cols, pad >= loopStartPad && pad < loopEndPad ? clipColor : COLOR_OUTSIDE);
        }
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN) {
            return;
        }
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (index >= 3) {
            return;
        }
        this.padResolution = index;
        this.surface.getDisplay().notify("1/" + PAD_RESOLUTIONS[this.padResolution]);
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (scene < 0 || scene >= 8) {
            return "BUTTON_COLOR_OFF";
        }
        if (scene < 3) {
            return scene == this.padResolution ? "COLOR_RESOLUTION_SELECTED" : "COLOR_RESOLUTION";
        }
        return "COLOR_RESOLUTION_OFF";
    }

    private double getQuartersPerPad() {
        return (double)this.transport.getQuartersPerMeasure() / (double)PAD_RESOLUTIONS[this.padResolution];
    }
}

