/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.TransposeView;
import java.util.Optional;

public abstract class AbstractDrum64View<S extends IControlSurface<C>, C extends Configuration>
extends AbstractView<S, C>
implements TransposeView {
    protected static final int DRUM_START_KEY = 36;
    protected static final int GRID_COLUMNS = 8;
    protected static final int BLOCK_SIZE = 16;
    protected int offsetY;
    protected int selectedPad = 0;
    protected int[] pressedKeys = new int[128];
    protected int columns;
    protected int rows;
    protected int drumOctave = 0;
    protected int drumStartKey = 36;
    private final int xblocks;
    private final int yblocks;
    private final int numPadGrid;

    protected AbstractDrum64View(S surface, IModel model) {
        this(surface, model, 8, 8);
    }

    protected AbstractDrum64View(S surface, IModel model, int columns, int rows) {
        super("Drum " + columns * rows, surface, model);
        this.columns = columns;
        this.rows = rows;
        this.numPadGrid = this.columns * this.rows;
        this.offsetY = this.drumStartKey;
        this.xblocks = this.columns / 4;
        this.yblocks = this.rows / 4;
        ITrackBank tb = model.getTrackBank();
        tb.addSelectionObserver((index, isSelected) -> this.clearPressedKeys());
        tb.addNoteObserver(this::updateNote);
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.getDrumPadBank().setIndication(true);
        this.resetOctave();
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.getDrumPadBank().setIndication(false);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - this.drumStartKey;
        int x = index % this.columns;
        int y = index / this.columns;
        int xblockPos = x / 4;
        int yblockPos = y / 4;
        int blocks = xblockPos * this.yblocks * 16 + yblockPos * 16;
        this.selectedPad = blocks + y % 4 * 4 + x % 4;
        int playedPad = velocity == 0 ? -1 : this.selectedPad;
        this.pressedKeys[this.offsetY + this.selectedPad] = velocity;
        if (playedPad < 0) {
            return;
        }
        this.handleButtonCombinations(playedPad);
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = this.surface.getPadGrid();
        if (!this.model.canSelectedTrackHoldNotes()) {
            padGrid.turnOff();
            return;
        }
        IDrumPadBank drumPadBank = this.getDrumPadBank();
        boolean isRecording = this.model.hasRecordingState();
        int blockOffset = 0;
        for (int xblock = 0; xblock < this.xblocks; ++xblock) {
            for (int yblock = 0; yblock < this.yblocks; ++yblock) {
                for (int blockX = 0; blockX < 4; ++blockX) {
                    for (int blockY = 0; blockY < 4; ++blockY) {
                        int index = blockOffset + blockY * 4 + blockX;
                        int x = xblock * 4 + blockX;
                        int y = yblock * 4 + blockY;
                        padGrid.lightEx(x, this.rows - 1 - y, this.getDrumPadColor(index, drumPadBank, isRecording));
                    }
                }
                blockOffset += 16;
            }
        }
    }

    private String getDrumPadColor(int index, IDrumPadBank drumPadBank, boolean isRecording) {
        if (this.pressedKeys[this.offsetY + index] > 0) {
            return isRecording ? "COLOR_PAD_RECORD" : "COLOR_PAD_PLAY";
        }
        if (this.selectedPad == index) {
            return "COLOR_PAD_SELECTED";
        }
        IDrumPad drumPad = drumPadBank.getItem(index);
        if (!drumPad.doesExist() || !drumPad.isActivated()) {
            return this.surface.getConfiguration().isTurnOffEmptyDrumPads() ? "COLOR_PAD_OFF" : "COLOR_PAD_NO_CONTENT";
        }
        if (drumPad.isMute() || drumPadBank.hasSoloedPads() && !drumPad.isSolo()) {
            return "COLOR_PAD_MUTED";
        }
        return this.getPadContentColor(drumPad);
    }

    protected String getPadContentColor(IChannel drumPad) {
        return DAWColor.getColorID(drumPad.getColor());
    }

    private void clearPressedKeys() {
        for (int i = 0; i < 128; ++i) {
            this.pressedKeys[i] = 0;
        }
    }

    @Override
    public void updateNoteMapping() {
        boolean turnOn = this.model.canSelectedTrackHoldNotes() && !this.surface.isSelectPressed() && !this.surface.isDeletePressed() && !this.surface.isMutePressed() && !this.surface.isSoloPressed();
        this.delayedUpdateNoteMapping(turnOn ? this.getDrumMatrix() : EMPTY_TABLE);
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.setOctave(this.drumOctave - 1);
        }
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.setOctave(this.drumOctave + 1);
        }
    }

    @Override
    public void resetOctave() {
        this.setOctave(0);
    }

    private void setOctave(int octave) {
        this.clearPressedKeys();
        this.drumOctave = Math.max(-2, Math.min(1, octave));
        this.offsetY = this.drumStartKey + this.drumOctave * 16;
        this.updateNoteMapping();
        this.surface.getDisplay().notify(this.getDrumRangeText());
        this.getDrumPadBank().scrollTo(this.offsetY);
    }

    @Override
    public boolean isOctaveUpButtonOn() {
        return this.drumOctave < 1;
    }

    @Override
    public boolean isOctaveDownButtonOn() {
        return this.drumOctave > -2;
    }

    protected void handleButtonCombinations(int playedPad) {
        if (this.surface.isDeletePressed()) {
            this.handleDeleteButton(playedPad);
        } else if (this.surface.isMutePressed()) {
            this.handleMuteButton(playedPad);
        } else if (this.surface.isSoloPressed()) {
            this.handleSoloButton(playedPad);
        } else if (this.surface.isSelectPressed() || this.surface.getConfiguration().isAutoSelectDrum()) {
            this.handleSelectButton(playedPad);
        }
        this.updateNoteMapping();
    }

    protected void handleDeleteButton(int playedPad) {
    }

    protected void handleMuteButton(int playedPad) {
        this.surface.setTriggerConsumed(ButtonID.MUTE);
        this.getDrumPadBank().getItem(playedPad).toggleMute();
    }

    protected void handleSoloButton(int playedPad) {
        this.surface.setTriggerConsumed(ButtonID.SOLO);
        this.getDrumPadBank().getItem(playedPad).toggleSolo();
    }

    protected void handleSelectButton(int playedPad) {
    }

    private int[] getDrumMatrix() {
        int[] noteMap = Scales.getEmptyMatrix();
        int blockOffset = 0;
        for (int xblock = 0; xblock < this.xblocks; ++xblock) {
            for (int yblock = 0; yblock < this.yblocks; ++yblock) {
                for (int blockX = 0; blockX < 4; ++blockX) {
                    for (int blockY = 0; blockY < 4; ++blockY) {
                        int index = blockOffset + blockY * 4 + blockX;
                        int x = xblock * 4 + blockX;
                        int y = yblock * 4 + blockY;
                        int note = this.drumStartKey + y * this.columns + x;
                        noteMap[note] = index + this.offsetY;
                        if (noteMap[note] >= -1 && noteMap[note] <= 127) continue;
                        noteMap[note] = -1;
                    }
                }
                blockOffset += 16;
            }
        }
        return noteMap;
    }

    private String getDrumRangeText() {
        int s = this.drumStartKey + this.drumOctave * this.numPadGrid;
        return Scales.formatDrumNote(s) + " to " + Scales.formatDrumNote(s + this.numPadGrid - 1);
    }

    public int getDrumOctave() {
        return this.drumOctave;
    }

    private void updateNote(int trackIndex, int note, int velocity) {
        Optional sel = this.model.getCurrentTrackBank().getSelectedItem();
        if (sel.isPresent() && ((ITrack)sel.get()).getIndex() == trackIndex) {
            this.pressedKeys[note] = velocity;
        }
    }

    protected IDrumPadBank getDrumPadBank() {
        return this.model.getDrumDevice(this.numPadGrid).getDrumPadBank();
    }
}

