/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.utils;

import de.mossgrabers.framework.utils.LatestTaskException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class LatestTaskExecutor
implements ExecutorService {
    private final AtomicReference<Runnable> lastTask = new AtomicReference();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    @Override
    public void execute(Runnable command) {
        this.lastTask.set(command);
        this.executor.execute(() -> {
            Runnable task = this.lastTask.getAndSet(null);
            if (task != null) {
                task.run();
            }
        });
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new LatestTaskException();
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new LatestTaskException();
    }

    @Override
    public Future<?> submit(Runnable task) {
        throw new LatestTaskException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new LatestTaskException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new LatestTaskException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new LatestTaskException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new LatestTaskException();
    }
}

